/**
 * Created by atignola on 4/25/2017.
 */

/**
 *
 * @param message
 * @param errorCode
 */
function notFound(message, errorCode) {

    let err;
    if (message instanceof Error){err = message;}
    else {err = new Error();}

    err.message = message || 'The requested resource couldn\'t be found';
    err.statusCode = 404;
    err.errorCode = errorCode || 404;
    return err;
};


function validationError(err, errorCode) {

    err.statusCode = 400;
    err.errorCode = errorCode || 400;

    return err;
};

function invalidData(message, errorCode) {
    let err;
    if (message instanceof Error){err = message;}
    else {err = new Error();}

    err.message = message || 'Invalid Data';
    err.statusCode = 400;
    err.errorCode = errorCode || 400;

    return err;
};

function serverIssue(message, errorCode) {
    let err;

    if (message instanceof Error){err = message;}
    else {err = new Error();}

    err.message = message || 'There was a problem with the server.';
    err.statusCode = 500;
    err.errorCode = errorCode || 500;

    return err;
};

function serverCreationIssue(message, errorCode) {
    let err;
    if (message instanceof Error){err = message;}
    else {err = new Error();}
    err.message = message || 'There was a problem creating/storing the data on the server.';
    err.statusCode = 500;
    err.errorCode = errorCode || 500;

    return err;
};

exports.notFound = notFound;
exports.invalidData = invalidData;
exports.serverIssue = serverIssue;
exports.serverCreationIssue = serverCreationIssue;
exports.validationError = validationError;