Vista Surgery API
=================

API to serve as broker for all calls to data store from GUI, scripts, etc...

Set up NodeJS to point to your local instance in .env file

To install server `'npm install'` this will install the node\_modules directory
locally

To start server `'npm start'` in root of the directory

To start server *in debug mode *`'npm run debug'` in root of the directory

===============================
\* Developer Environment Setup \*
===============================

This document was created to help new developers set up their local developer
environment to help reduce any down time that is associated with installing and
configuring applications during initial setup. This document may not include
every step necessary but it will provide a foundation for a new developer to get
started. Please provide any updates to this document as you see fit. Please note
that these instructions were created from a Windows environment and this will
not include steps for a Unix/Linux environment until someone else provides
input.

Install/Configure Node.js
-------------------------

Please download Node.js Version: 4.6.x from the following link:

[https://nodejs.org/en/download/releases/](https://nodejs.org/en/download/releases/)


-   If you are running windows you can download the appropriate binary (.msi)
    file or zip file.

    -   If you downloaded the binary file, you can run the installer.

    -   If you downloaded the zip file, you will need to extract the archive to
        a directory of your choice and follow any instructions for configuring
        your environment variables (Please refer to README file contained in
        archive).

-   If you are running Unix or Linux you need to download the appropriate
    archive file and follow the instructions contained in the archive file.

When finished with the installation, confirm your version with the following
command: node -v

You should see something like the following: v4.6.0

Install/Configure MongoDB
-------------------------

See the following link for MongoDB installation/configuration

[https://docs.mongodb.com/manual/tutorial/install-mongodb-on-windows/](https://docs.mongodb.com/manual/tutorial/install-mongodb-on-windows/)

Install/Configure Wireshark
---------------------------

Download the appropriate version of WireShark for your system from the
following:

[https://www.wireshark.org/download.html](https://www.wireshark.org/download.html)


Run the installer and you should be set.

You will most likely want to filter the traffic that is being monitored for the
VistA server only.

In order to do this: - Select the blue bookmark icon that is to the left of the
"Apply a display filter" text area, just below the toolbar icons. - Choose
"Manage Display Filters". - Click the add (plus sign) button - Configure filter
with following settings Name: dbITpro VistA Server Filter: ip.addr ==
74.102.74.34 - Click OK - Select the blue bookmark icon again and choose the new
filter from the bottom of the list. - Select the blue and white arrow icon in
the right of the text area to apply the filter. - You're done!

Install/Configure CPRS
----------------------

Download the CPRS client software from the following site (I do not know of a
Linux/Unix version):

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
http://worldvista.org/Software_Download/worldvista_ehr_v2_clients
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

-   Extract the "VistA" folder of the archive file to your C: drive to include
    the "Commons Files" and "CPRS".

-   Navigate to the CPRS folder

-   Create a shortcut for the "CPRSChart\_27.90ForWVEHR-2.0-Ver10-12.exe" file

-   Right click the shortcut and choose properties

-   Change the Target to read the following:
    C:\VistA\CPRS\CPRSChart\_27.90ForWVEHR-2.0-Ver10-12.exe s=74.102.74.34
    p=9211 CCOW=disable showrpcs

-   Double click the shortcut to start the CPRS client application

-   Enter the Access/ Verify Codes that you were provided from the dbITpro POC

-   If you did not receive an Access and Verify code, please contact: Sean
    Cassidy

    -   email: sean.cassidy\@dbitpro.com



## Postman
----------------------
Postman is a tool for testing the API. You can install Postman from here:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
http://www.getpostman.com
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Once installed launch Postman and **"Import"** the **"VistaSurgeryAPI.postman_collection"** file from the root of the API folder.
Then you can run any of the requests from the VistA Surgery API collection.
First, run the **"POST Authentication"** request. You should receive a body that looks like this:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
{
  "success": true,
  "message": "Enjoy your token!",
  "token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJhY2Nlc3MiOiJ0ZXN0IiwidmVyaWZ5IjoidGVzdCIsImV4cCI6MTQ3Njk3MjAyNSwiaXNzIjoidmlzdGEtc3VyZ2VyeS1hcGkiLCJhdWQiOiJ2aXN0YS1zdXJnZXJ5LWFwaSIsImlhdCI6MTQ3Njk3MDIyNX0.feeAqFb98517Oqz-nYQ4BwmKCjbboGIop1tPvYBAas8"
}
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

Then take the value of the **"token"** key and insert it into the value for the **"Authorization"** header in the **"GET Successful Authentication"** request. After that you should be able to **"Send"** and receive the following message:
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Authenticated: hello world
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
This token expires every 40 minutes or so. So if you receive a 401 error, just go back and get a new token via the **"POST Authentication"** request.
