/**
 * Form Generator module -
 *
 **/

"use strict";

const Marionette            = require("backbone.marionette");
const FormGeneratorConfig   = require("./form-generator-config.json");
const IndexView             = require("../modules/index/view");
const Radio                 = require("backbone.radio");

module.exports = {

  // This function populates the JSON object called FormGeneratorConfig defined later in this file
  createJSONObject: function(config, data) {

    // Remove all elements of this array in cases the form is generated again
    FormGeneratorConfig.form.items.length = 0;

    // Set form title
    if(config.form.title != "")
      FormGeneratorConfig.form.title = config.form.title;

    // Set the width of elements like text and select fields for panels or modals
    let elementWidthClass = (config.form.type == "panel") ? "field-width-panel" : "";

    // Set the CSS for fields in tab forms that will be laid out side-by-side in the Case Filter page
    let formControlClass = (config.form.title == "Case Filter") ? "tab-form-control" : "form-control";

    let additionalClass = "";
    let index = 0;

    // Loop fills up FormGeneratorConfig JSON fields object array
    $.each(config.form.fields, function(key, value) {

      // Debug
      //console.log(key + " - " + value);

      // Set the width of elements like text and select fields for case filter form

      if(index % 2 == 0)
        additionalClass = (config.form.title == "Case Filter") ? "tab-field-specs-left" : "";
      else
        additionalClass = (config.form.title == "Case Filter") ? "tab-field-specs-right" : "";

      let selectFieldTemplate = {
        "type": "select",
        "div": {
          "id": "",
          "class": "",
          "role": ""
        },
        "label": {
          "id": "",
          "class": "",
          "for": "",
          "text": ""
        },
        "element": {
          "id": "",
          "class": "",
          "name": "",
          "title": "",
          "required": "",
          "size": "1",
          "tabindex": "1",
          "ariahidden":"true",
          "innerHtml": []
        }
      };

      let textFieldTemplate = {
        "type": "input",
        "div": {
          "id": "",
          "class": ""
        },
        "label": {
          "id": "",
          "class": "",
          "for": "",
          "text": ""
        },
        "element": {
          "id": "",
          "class": "",
          "name": "",
          "title": "",
          "type": "",
          "required": "",
          "autocomplete": "off",
          "maxlength": "255",
          "value": ""
        }
      };

      // Resolve field text label
      let labelText = "";
      if(value != null && value != "" && !(value instanceof Array))
      {
        labelText = value;
      }
      else
      {
        // Enable concatenated one-word keys to have title cases for all form labels
        let keyTemp = key.charAt(0).toUpperCase() + key.slice(1);
        let keyArray = keyTemp.match(/[A-Z][a-z]+/g);

        if(keyArray != null) {
          for (var i = 0; i < keyArray.length; i++) {
            labelText += keyArray[i] + " ";
          }
        } else {
          labelText = keyTemp;
        }
      }

      // Deal with cases whereby a value is an array, in which cases it would be put into a select box
      if((value instanceof Array)) {

        // Div
        selectFieldTemplate.div.id = key + "Div";
        selectFieldTemplate.div.class = `control form-group select-control selectedFacility ${elementWidthClass} ${additionalClass}`;
        selectFieldTemplate.div.role = "combobox";

        // Label
        selectFieldTemplate.label.id = key + "Label";
        selectFieldTemplate.label.class = key + "Label";
        selectFieldTemplate.label.for = key;
        selectFieldTemplate.label.text = labelText;

        // Element
        selectFieldTemplate.element.id = key;
        selectFieldTemplate.element.class = `${formControlClass} select2-hidden-accessible`;
        selectFieldTemplate.element.name = key + "Name";
        selectFieldTemplate.element.title = key + "Title";
        selectFieldTemplate.element.innerHtml = value;

        FormGeneratorConfig.form.items.push(selectFieldTemplate);

      } else {

        // Div
        textFieldTemplate.div.id = key + "Div";
        textFieldTemplate.div.class = `control form-group input-control accessCode ${elementWidthClass} ${additionalClass}`;

        // Label
        textFieldTemplate.label.id = key + "Label";
        textFieldTemplate.label.class = key + "Label";
        textFieldTemplate.label.for = key;
        textFieldTemplate.label.text = labelText;

        // Element
        textFieldTemplate.element.id = key;
        textFieldTemplate.element.class = formControlClass;
        textFieldTemplate.element.name = key + "Name";
        textFieldTemplate.element.title = key + "Title";
        textFieldTemplate.element.type = "text";
        textFieldTemplate.element.value = (data != null && data[key] != null) ? data[key] : "";

        FormGeneratorConfig.form.items.push(textFieldTemplate);

      }

      index++;

    }); // End of loop

    // Now add any buttons to FormGeneratorConfig JSON object
    $.each(config.form.buttons, function(key, value) {
      FormGeneratorConfig.form.items.push(value);
    });

    // Debug - This is actually the JSON output which can be put into a config file after formatting (jsbeautifier.com)
    //console.log(JSON.stringify(FormGeneratorConfig));
  },


  // This function creates a form out of the FormGeneratorConfig array object which embodies a JSON field configuration for each
  // element in the array. The function is equipped to handle text fields, select boxes or buttons. The final output is
  // HTML and it is appended to the output DIV in the body of the modal template.
  createForm: function(fieldsContainer, buttonsContainer) {

    // Get the fields array from FormGeneratorConfig which was prepared earlier
    let items = FormGeneratorConfig.form.items;

    // Define the "parent" JSON items for each field
    let itemType;
    let div;
    let label;
    let elem;

    // Define the final HTML variable which will be appended to the output div
    let fieldsHtml = "";
    let buttonsHtml = "";

    // Loop through each field and come up with its HTML
    for (let i in items)
    {
      itemType = items[i].type;
      div = items[i].div;
      label = (items[i].label != null)?items[i].label:null;
      elem = items[i].element;

      if(itemType == "button")
      {
        buttonsHtml += `\n<div id="${div.id}" class="${div.class}">`;
        buttonsHtml += `\n\t<${itemType} id="${elem.id}" class="${elem.class}" name="${elem.name}" type="${elem.type}" title="${elem.title}"`;

        let xxxdatadismiss = (elem.xxxdatadismiss != null && elem.xxxdatadismiss != "") ? `xxxdata-dismiss="${elem.xxxdatadismiss}" ` : "";
        let innerHtml = (elem.innerHtml != null && elem.innerHtml != "") ? elem.innerHtml : "";

        buttonsHtml += xxxdatadismiss;
        buttonsHtml += ">";
        buttonsHtml += "\n\t" + innerHtml;
        buttonsHtml += `\n\t</${itemType}>`;
        buttonsHtml += "\n</div>";
      }
      else
      {
        fieldsHtml += `\n<div id="${div.id}" class="${div.class}">`;
        fieldsHtml += (label != null) ? `\n<label for="${label.for}">${label.text}</label>` : "";
        fieldsHtml += `\n<${itemType} id="${elem.id}" class="${elem.class}" name="${elem.name}" title="${elem.title}"`;

        let type = (elem.type != null && elem.type != "") ? `type="${elem.type}" ` : "";
        let value = (elem.value != null && elem.value != "") ? `value="${elem.value}" ` : "";
        let required = (elem.required != null && elem.required != "") ? `required="${elem.required}" ` : "";
        let autocomplete = (elem.autocomplete != null && elem.autocomplete != "") ? `autocomplete="${elem.autocomplete}" ` : "";
        let maxlength = (elem.maxlength != null && elem.maxlength != "") ? `maxlength="${elem.maxlength}" ` : "";
        let size = (elem.size != null && elem.size != "") ? `size="${elem.size}" ` : "";
        let tabindex = (elem.tabindex != null && elem.tabindex != "") ? `tabindex="${elem.tabindex}" ` : "";
        let ariahidden = (elem.ariahidden != null && elem.ariahidden != "") ? `aria-hidden="${elem.ariahidden}" ` : "";
        let xxxdatadismiss = (elem.xxxdatadismiss != null && elem.xxxdatadismiss != "") ? `xxxdata-dismiss="${elem.xxxdatadismiss}" ` : "";

        // Handle select fields and buttons inner HTML (not needed for text fields)
        let innerHtml = "";
        if(elem.innerHtml instanceof Array) {

          $.each(elem.innerHtml, function(key, value) {
            if(value.id != null && value.name != null) {
              innerHtml += `\n\t<option value="${value.id}">${value.name}</option>`;
            }
            else {
              innerHtml += `\n\t<option value="${value}">${value}</option>`;
            }
          });

        } else {

          innerHtml = (elem.innerHtml != null && elem.innerHtml != "") ? elem.innerHtml : "";
        }

        fieldsHtml += type;
        fieldsHtml += value;
        fieldsHtml += required;
        fieldsHtml += autocomplete;
        fieldsHtml += maxlength;
        fieldsHtml += size;
        fieldsHtml += tabindex;
        fieldsHtml += ariahidden;
        fieldsHtml += ">";
        fieldsHtml += "\n" + innerHtml;
        fieldsHtml += `\n</${itemType}>`;
        fieldsHtml += "\n</div>";

      } // end of if
    } // end of for

    // Set the window title and display html for newly created form
    if(FormGeneratorConfig.form.title != "")
      $("#formWindowTitle").empty().html(FormGeneratorConfig.form.title);

    $(fieldsContainer).html(fieldsHtml);
    $(buttonsContainer).html(buttonsHtml);
  },

  closeDialog:  function() {
    Backbone.history.navigate( "/", { trigger: false, replace: true } );
    $(".modal-dialog").remove();
    $(".modal-backdrop").remove();
    Radio.request("root", "body", new IndexView({})); // Redirect to About view
  },

  openHelpWindow:  function() {
    let href = "https://ehmp.vistacore.us/help/eHMP_Page%20Not%20Found.htm";
    let left = (screen.width/2)-(900/2);
    let top = (screen.height/2)-(600/2);

    window.open(href, "Widget Help", `top=${top}, left=${left}, width=800, height=450`);
    return false;
  }
};
