const Sciatic = require("backbone.sciatic");
const Radio = require("backbone.radio");

module.exports = Sciatic.Router.extend({
	filters: [
		{
			before(routeData) {
				// Set the currently logged-in user to the routeData
				// on every route transition
				routeData._user = Radio.request("auth", "user");
			}
		}
	],

	routes: {
		"":                       require("./modules/index/route"),
		"login/":                 require("./modules/login/route"),
		"selpatient/":            require("./modules/sel_patient/route"),
		"casefilter/":            require("./modules/list/case_filter/route"),
		"calendar/":              require("./modules/calendar/route")
	}
});
