// const _          = require("underscore");
const Marionette = require("backbone.marionette");
const Radio      = require("backbone.radio");
const storage    = require("../../utils/storage");
const aheader    = require("../../utils/authHeaders");
const PatientNameCollection   = require("../../entities/sel_patient/patient_all/collection");
const SelPatientShowView = require("./show/view");
//const PatientLast5Model  = require("../../entities/sel_patient/patient_last5/model");

module.exports = Marionette.View.extend({
	template: require("./template.hbs"),

	ui: {
		nameField: "#PatientInfo"
	},

	onAttach: function() {
    this.loadPatientList();
	},

	loadPatientList() {
		this.collection = new PatientNameCollection();
		return this.collection.fetch(aheader())
			.then(() => this.initTypeahead());
	},

	initTypeahead() {
		const patients = this.collection;

		this.getUI("nameField").typeahead({
			minLength: 3,
			highlight: true
		},
		{
			name: "patient-data",
			source(query, callback) {

				const results = patients.filter((patient) => {
					let ck1 = patient.get("name").toLowerCase().indexOf(query.toLowerCase()) > -1;
					let ck2 = patient.get("lastFive").toLowerCase().indexOf(query.toLowerCase()) > -1;
					return ck1 | ck2;
				});

				console.log("Matching patients", results);
				let theMap = results.map(r => (r.get("name") + " - " + r.get("lastFive")));   // Note: Building of this string must match the stripping off done in "onClickSelectPatient()"
				callback(theMap);
			}
		});
	},

	triggers: {
		"click #selectPatientButton": "click:selectPatient"
	},

	onClickSelectPatient() {
		let selectedName = this.getUI("nameField").val();
		selectedName = selectedName.substring(0, selectedName.indexOf(" - "));  // strip off the LastFive
		const singlePatientRecord = this.collection.findWhere({name: selectedName});
		console.log("Single Patient Record::", singlePatientRecord.toJSON());
		Radio.request("root", "modal", {
			view: new SelPatientShowView({model: singlePatientRecord})
		});
	}
/****************************
	onClickSelectPatient() {
		let selectedName = this.getUI("nameField").val();
		selectedName = selectedName.substring(0, selectedName.indexOf(" - "));  // strip off the LastFive

		const matches = selectedName.match(/\d+/g);
		if (matches != null) {

			const patient5 =  new PatientLast5Model({id: selectedName});

			patient5.fetch(aheader());
			console.log(patient5.toJSON());
			Radio.request("root", "modal", {view: new SelPatientShowView({model: patient5.toJSON()})});
		}

		else {
			const singlePatientRecord = this.collection.findWhere({name: selectedName});

			console.log("Single Patient Record::", singlePatientRecord.toJSON());

			Radio.request("root", "modal", {
				view: new SelPatientShowView({model: singlePatientRecord})
			});
		}
	}
********************/
});
