const Marionette = require("backbone.marionette");
const Radio      = require("backbone.radio");

module.exports = Marionette.View.extend({
	template: require("./template.hbs"),
	triggers: {
		"click #ConfirmPatientSelection": "click:selectPatient"
	},

	onClickSelectPatient() {
		console.log("Save to LocalStorage:", this.model);

		this.model.saveToLocalStorage();

		Radio.request("store", "set", "activePatient", this.model);
		Radio.request("root", "close:modal");
	}
});
