const Sciatic         = require("backbone.sciatic");
const Radio           = require("backbone.radio");
const PostsView       = require("./view");
const PostsCollection = require("../../entities/posts/collection");

module.exports = Sciatic.Route.extend({
	fetch(routeData) {
		routeData.posts = new PostsCollection();
		return routeData.posts.fetch();
	},

	show(routeData) {
		Radio.request("root", "body", new PostsView({
			collection: routeData.posts
		}));
	}
});
