const mn = require("backbone.marionette");

module.exports = mn.View.extend({
	template: require("./template.hbs"),

	ui: {
		modal: ".js-modal"
	},

	regions: {
		main: ".js-region-main"
	},

	events: {
		// Handles destroying the view once the bootstrap modal has been dismissed
		"hidden.bs.modal @ui.modal": "destroy"
	},

	show: true,
	keyboard: true,
	backdrop: true,

	onClose() {
		this.ui.modal.modal("hide");
	},

	onAttach() {
		const modalOptions = {
			show: this.getOption("show"),
			keyboard: this.getOption("keyboard"),
			backdrop: this.getOption("backdrop")
		};

		this.ui.modal.modal(modalOptions);
		this.showChildView("main", this.getOption("view"));
	}
});
