const Sciatic = require("backbone.sciatic");
const Radio = require("backbone.radio");
const LoginView = require("./view");
const storage = require("../../utils/storage");

module.exports = Sciatic.Route.extend({
	show({ query }) {
		const returnUrl = query.return || "";

		// We don't need to log in if the user already has
		// an authentication token.
		if (storage.getItem("access_token")) {
			return this.navigate(returnUrl, { trigger: true, replace: true });
		}

		Radio.request("root", "modal", {
			view: new LoginView({ returnUrl }),
			keyboard: false,
			backdrop: "static"
		});
	}
});
