"use strict";

const Marionette                    = require("backbone.marionette");
const formGenerator                 = require("../../utils/form-generator");
const PatientProcedureInfoConfig    = require("./patientAndProcedureInfo.json");
const TimeStaffInfoConfig           = require("./timeAndStaffInfo.json");
const IntraoperativeInfoConfig      = require("./intraoperativeInfo.json");
const SpecialCaseNeedsInfoConfig    = require("./specialCaseNeedsInfo.json");

let dataObj = new Object();

module.exports = Marionette.View.extend({
  "className": "starter-template",
  "template": require("./template.hbs"),

  events: {
    "click #tag1":  function (e) {
      PatientProcedureInfoConfig.form.title = "";
      formGenerator.createJSONObject(PatientProcedureInfoConfig, dataObj);
      formGenerator.createForm("#tabContentDiv1", "#tabButtonsDiv1");
    },

    "click #tag2":  function (e) {
      TimeStaffInfoConfig.form.title = "";
      formGenerator.createJSONObject(TimeStaffInfoConfig, dataObj);
      formGenerator.createForm("#tabContentDiv2", "#tabButtonsDiv2");
    },

    "click #tag3":  function (e) {
      IntraoperativeInfoConfig.form.title = "";
      formGenerator.createJSONObject(IntraoperativeInfoConfig, dataObj);
      formGenerator.createForm("#tabContentDiv3", "#tabButtonsDiv3");
    },

    "click #tag4":  function (e) {
      SpecialCaseNeedsInfoConfig.form.title = "";
      formGenerator.createJSONObject(SpecialCaseNeedsInfoConfig, dataObj);
      formGenerator.createForm("#tabContentDiv4", "#tabButtonsDiv4");
    },

    "click #cancelTab1, #cancelTab2, #cancelTab3, #cancelTab4":  function (e) {
      formGenerator.closeDialog();
    },
  },

  onAttach() {
    //formGenerator.createJSONObject(PatientProcedureInfoConfig);
    formGenerator.createForm("#tabContentDiv1", "#tabButtonsDiv1");
    this.updateBodyPanelCSS();
  },

  initialize: function(options) {
    jQuery(document).ready(function() {
      jQuery('.tabs .tab-links a').on('click', function(e)  {
        var currentAttrValue = jQuery(this).attr('href');

        // Show/Hide Tabs
        jQuery('.tabs ' + currentAttrValue).show().siblings().hide();

        // Change/remove current tab to active
        jQuery(this).parent('li').addClass('active').siblings().removeClass('active');

        e.preventDefault();
      });
    });

    $(window).on("resize", this.updateBodyPanelCSS);

    // Debug
    //console.log(JSON.stringify(options.results));

    dataObj = options.results;
    PatientProcedureInfoConfig.form.title = "";
    formGenerator.createJSONObject(PatientProcedureInfoConfig, dataObj);
  },

  updateBodyPanelCSS: function() {

    // Again, on window resizing, this dymaically sets up a fixed height resizable tab content
    $('#tabContentDiv1').css({'height':(($(window).height())-288)+'px'}).css({'overflow-y':'auto'});
    $('#tabContentDiv2').css({'height':(($(window).height())-288)+'px'}).css({'overflow-y':'auto'});
    $('#tabContentDiv3').css({'height':(($(window).height())-288)+'px'}).css({'overflow-y':'auto'});
    $('#tabContentDiv4').css({'height':(($(window).height())-288)+'px'}).css({'overflow-y':'auto'});
  }

});
