const Marionette                    = require("backbone.marionette");
const Radio                         = require("backbone.radio");
const authHeaders                   = require("../../../utils/authHeaders");
const formGenerator                 = require("../../../utils/form-generator");
const CaseCollection                = require("../../../entities/case/collection");
const IndexView                     = require("../../../modules/index/view");
const ListView                      = require("../view");
//const SurgeonSummaryInfoConfig      = require("../surgeonSummaryInfo.json");
const PatientProcedureInfoConfig    = require("../patientAndProcedureInfo.json");
const TimeStaffInfoConfig           = require("../timeAndStaffInfo.json");
const IntraoperativeInfoConfig      = require("../intraoperativeInfo.json");
const SpecialCaseNeedsInfoConfig    = require("../specialCaseNeedsInfo.json");
const storage                       = require("../../../utils/storage");

let resultsHtml = "";
let resultsObj = new Object();
let singleCaseObj = new Object();
let expandedMode = true;
let expandedOffsetFactor = 537;
let collapsedOffsetFactor = 288;
let filterTypeValue = "Specialty";
let disabledState = false;
let typeaheadQuery = "";

module.exports = Marionette.View.extend({
  template: require("./template.hbs"),
  ui: {
    formxxx: "#cfForm",
    typeaheadField: "#filterData"
  },

  events: {

    "click #expand-collapse": function(e) {
      // Toggle plus/minus button, adjust tab panel upper margin depending on mode, toggle tab panel height
      $("#caseFilterPanel").slideToggle();
      $("#expand-collapse").toggleClass("fa fa-caret-down fa fa-caret-right");
      $("#tabPanel").toggleClass("tab-panel-top-margin");
      expandedMode = !expandedMode;
      this.updateBodyPanelCSS();
    },

    "click #patientCB":  function (e) {
      disabledState = !disabledState;
      $("#placeholderCB").attr("disabled", disabledState);
    },

    "click #placeholderCB":  function (e) {
      disabledState = !disabledState;
      $("#patientCB").attr("disabled", disabledState);
    },

    "change #filterType":  function (e) {
      filterTypeValue = $("#filterType").val();
    },

    "click #cancel":  function (e) {
      Backbone.history.navigate( "/", { trigger: false, replace: true } );
      Radio.request("root", "body", new IndexView({}));
    },

    "click #clear":  function (e) {
      $("#filterData").val("");
      $("#filterResultsPanel").hide();
      $("#caseFilterMsgDiv").remove(); // if there
      $("#tabPanel").hide();
    },

    "click #newCase":  function (e) {
      Backbone.history.navigate( "list/", { trigger: false, replace: true } );
      Radio.request("root", "body", new ListView({}));
    },

    "click #search": function(e) {
      let filterType = $("#filterType").val();
      let filterData = $("#filterData").val();

      // Debug
      //console.log("Filter Type: " + filterType);
      //console.log("Filter Data: " + filterData);

      if (filterType == "" || filterData == "") {

        // Remove error div (if there), show error message, and hide other page components
        let message = "Please enter relevant data";
        $("#caseFilterMsgDiv").remove();
        $("#formContainer").after(`<div id="caseFilterMsgDiv" class="resultMsg resultMsgError">${message}</div>`);
        $("#filterResultsPanel").hide();
        $("#tabPanel").hide();

      } else {

        resultsHtml = "";
        resultsHtml += `\n<div id="listHeader" class="cfh-li-header">`;
        resultsHtml += `\n\t<div id="listHeader" class="cf-li-header-left-div">CASE ID</div>`;
        resultsHtml += `\n\t<div id="listHeader" class="cf-li-header-right-div">PRINCIPAL PROCEDURE</div>`;
        resultsHtml += "\n</div>";
        resultsHtml += `\n<ul id="list" class="cf-ul">`;

        // Loop through case list results and create unordered list for it
        let liStyle = "cf-li";
        $.each(hcJSONDataResponse, function(key, value) {
        //$.each(this.collection, function(key, value) {

          resultsHtml += `\n\t<li id="${value.ien}" class="${liStyle}">`;
          resultsHtml += `\n\t\t<div id="${value.ien}" class="cf-li-left-div">${value.ien}</div>`;
          resultsHtml += `\n\t\t<div id="${value.ien}" class="cf-li-right-div">${value.principalProcedure}</div>`;
          resultsHtml += "\n\t</li>";

          resultsObj[value.ien] = value;
        });

        resultsHtml += "\n</ul>";

        // Display unordered case list html, hide tabs (if  open), remove error message (if there) and reset title
        $("#filterResultsContent").html(resultsHtml);
        $("#filterResultsPanel").show();
        $("#tabPanel").hide();
        $("#caseFilterMsgDiv").remove();
        $("#titleAddition").text("").removeClass("cf-title-addition");
      }
    },

    "click #list": function(e) {

      // Re-initiate dynamic tab functionality
      jQuery(document).ready(function() {
        jQuery(".tabs .tab-links a").on("click", function(e)  {
          var currentAttrValue = jQuery(this).attr("href");

          // Show/Hide Tabs
          jQuery(`.tabs ${currentAttrValue}`).show().siblings().hide();

          // Change/remove current tab to active
          jQuery(this).parent("li").addClass("active").siblings().removeClass("active");

          e.preventDefault();
        });
      });

      // Fill up all tab forms with the appropriate data
      singleCaseObj = resultsObj[e.target.id];
      //formGenerator.createJSONObject(SurgeonSummaryInfoConfig, singleCaseObj);
      //formGenerator.createForm("#tabContentDiv1", "#tabButtonsDiv1");
      formGenerator.createJSONObject(PatientProcedureInfoConfig, singleCaseObj);
      formGenerator.createForm("#tabContentDiv2", "#tabButtonsDiv2");
      formGenerator.createJSONObject(TimeStaffInfoConfig, singleCaseObj);
      formGenerator.createForm("#tabContentDiv3", "#tabButtonsDiv3");
      formGenerator.createJSONObject(IntraoperativeInfoConfig, singleCaseObj);
      formGenerator.createForm("#tabContentDiv4", "#tabButtonsDiv4");
      formGenerator.createJSONObject(SpecialCaseNeedsInfoConfig, singleCaseObj);
      formGenerator.createForm("#tabContentDiv5", "#tabButtonsDiv5");

      this.updateBodyPanelCSS();

      // Show the tab panel below the case list results
      $("#tabPanel").show();

      // Highlight the selected case a different color and reset the other case colors in the list
      $(".cf-li").each(function() {
        if(this.id == e.target.id)
          $(this).addClass("highlighted-li");
        else
          $(this).removeClass("highlighted-li");
      });

      // Put principal procedure into the title"
      $("#titleAddition").text(e.target.id + " - " + $("#principalProcedure").val()).addClass("cf-title-addition");
    },

    "click #cancelTab1, #cancelTab2, #cancelTab3, #cancelTab4":  function (e) {
      formGenerator.closeDialog();
    },

    "click #saveTab1, #saveTab2, #saveTab3, #saveTab4":  function (e) {
      Radio.request("store", "set", "activeCase", singleCaseObj);
      formGenerator.closeDialog();
    }
  },

  initialize: function() {
    $(window).on("resize", this.updateBodyPanelCSS);
  },

  onAttach: function() {
    this.ui.formxxx.show();
    $("#filterResultsPanel").hide();
    $("#tabPanel").hide();

    let activePatient = Radio.request("store", "get", "activePatient")
    if(activePatient != null) {
      console.log("Patient name: " + activePatient.get("name"));
      $("#patientLabel").text(`${activePatient.get("name")}`);
    }

    this.updateBodyPanelCSS();
    this.loadCaseList();
  },

  updateBodyPanelCSS: function() {

    let zoomLevel = null;
    let screenCssPixelRatio = (window.outerWidth - 8) / window.innerWidth;

    if (expandedMode) {

      if (screenCssPixelRatio >= .46 && screenCssPixelRatio <= .51) {
        zoomLevel = "-5";
        expandedOffsetFactor = 610;
        //$("#tabContentDiv1").css({"height": ""});
        $("#tabContentDiv2").css({"height": ""});
        $("#tabContentDiv3").css({"height": ""});
        $("#tabContentDiv4").css({"height": ""});
        $("#tabContentDiv5").css({"height": ""});
      } else if (screenCssPixelRatio <= .68) {
        zoomLevel = "-4";
        expandedOffsetFactor = 571;
        //$("#tabContentDiv1").css({"height":(($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": ""});
        $("#tabContentDiv4").css({"height": ""});
        $("#tabContentDiv5").css({"height": ""});
      } else if (screenCssPixelRatio <= .76) {
        zoomLevel = "-3";
        expandedOffsetFactor = 561;
        //$("#tabContentDiv1").css({"height":(($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": ""});
        $("#tabContentDiv4").css({"height": ""});
        $("#tabContentDiv5").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else if (screenCssPixelRatio <= .81) {
        zoomLevel = "-2";
        expandedOffsetFactor = 556;
        //$("#tabContentDiv1").css({"height":(($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": ""});
        $("#tabContentDiv4").css({"height": ""});
        $("#tabContentDiv5").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else if (screenCssPixelRatio <= .91) {
        zoomLevel = "-1";
        expandedOffsetFactor = 544;
        //$("#tabContentDiv1").css({"height":(($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv4").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv5").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else if (screenCssPixelRatio <= 1.01) {
        zoomLevel = "0";
        expandedOffsetFactor = 538;
        //$("#tabContentDiv1").css({"height":(($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv4").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv5").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else if (screenCssPixelRatio <= 1.11) {
        zoomLevel = "1";
        expandedOffsetFactor = 528;
        //$("#tabContentDiv1").css({"height":(($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv4").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv5").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else if (screenCssPixelRatio <= 1.26) {
        zoomLevel = "2";
        expandedOffsetFactor = 554;
        //$("#tabContentDiv1").css({"height":(($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv4").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv5").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else if (screenCssPixelRatio <= 1.51) {
        zoomLevel = "3";
        expandedOffsetFactor = 588;
        //$("#tabContentDiv1").css({"height":(($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv4").css({"height": (($(window).height()) - (expandedOffsetFactor + 2)) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv5").css({"height": (($(window).height()) - expandedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else {
        zoomLevel = "unknown";
      }

    } else {

      if (screenCssPixelRatio >= .46 && screenCssPixelRatio <= .81) {
        zoomLevel = "-5";
        //$("#tabContentDiv1").css({"height": ""});
        $("#tabContentDiv2").css({"height": ""});
        $("#tabContentDiv3").css({"height": ""});
        $("#tabContentDiv4").css({"height": ""});
        $("#tabContentDiv5").css({"height": ""});
      } else if (screenCssPixelRatio <= .91) {
        zoomLevel = "-1";
        //$("#tabContentDiv1").css({"height":(($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": ""});
        $("#tabContentDiv4").css({"height": ""});
        $("#tabContentDiv5").css({"height": ""});
      } else if (screenCssPixelRatio <= 1.01) {
        zoomLevel = "0";
        //$("#tabContentDiv1").css({"height":(($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": ""});
        $("#tabContentDiv4").css({"height": ""});
        $("#tabContentDiv5").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else if (screenCssPixelRatio <= 1.11) {
        zoomLevel = "1";
        //$("#tabContentDiv1").css({"height":(($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": ""});
        $("#tabContentDiv4").css({"height": ""});
        $("#tabContentDiv5").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else if (screenCssPixelRatio <= 1.26) {
        zoomLevel = "2";
        //$("#tabContentDiv1").css({"height":(($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": ""});
        $("#tabContentDiv4").css({"height": ""});
        $("#tabContentDiv5").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else if (screenCssPixelRatio <= 1.51) {
        zoomLevel = "3";
        //$("#tabContentDiv1").css({"height":(($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y":"auto"});
        $("#tabContentDiv2").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv3").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv4").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
        $("#tabContentDiv5").css({"height": (($(window).height()) - collapsedOffsetFactor) + "px"}).css({"overflow-y": "auto"});
      } else {
        zoomLevel = "unknown";
      }
    }
  },

  /**
   * Method that gets called when view is first displayed,
   * fetching the full list of cases for selection
   */
  loadCaseList() {
    this.collection = new CaseCollection();
    return this.collection.fetch(authHeaders())
      .then(() => this.initTypeahead());
  },

  initTypeahead() {

    let activeCases = this.collection;

    // Debug
    //console.log(JSON.stringify(activeCases));

    // Set the data for the various filter types since this data is all null inexplicably

    // Specialty
    activeCases.models[0].set("surgerySpecialty", "Neurological Surgery");
    activeCases.models[1].set("surgerySpecialty", "Ophthalmic Surgery");
    activeCases.models[2].set("surgerySpecialty", "Orthopaedic Surgery");
    activeCases.models[3].set("surgerySpecialty", "Thoracic Surgery");

    // Provider
    activeCases.models[0].set("attendingProvider", "Anatoly Vekrenov - Provider");
    activeCases.models[1].set("attendingProvider", "Bernard Barley - Provider");
    activeCases.models[2].set("attendingProvider", "David Smith - Provider");
    activeCases.models[3].set("attendingProvider", "Zlatan Moncho - Provider");

    // Staff Member
    activeCases.models[0].set("primarySurgeon", "Otto Kint - PS");
    activeCases.models[1].set("primarySurgeon", "Olajide Ochefu - PS");
    activeCases.models[2].set("primarySurgeon", "Pinar Yilmaz - PS");
    activeCases.models[3].set("primarySurgeon", "Wilson Martinez - PS");

    activeCases.models[0].set("attendingSurgeon", "Adam Karbacher - AS");
    activeCases.models[1].set("attendingSurgeon", "Carlos Litbarski - AS");
    activeCases.models[2].set("attendingSurgeon", "Gunther Thomas - AS");
    activeCases.models[3].set("attendingSurgeon", "William Horst - AS");

    activeCases.models[0].set("firstAsst", "Adan Swackhammer - FA");
    activeCases.models[1].set("firstAsst", "Will Sikahema - FA");
    activeCases.models[2].set("firstAsst", "Julio Velasco - FA");
    activeCases.models[3].set("firstAsst", "Amanda Wilhite - FA");

    activeCases.models[0].set("secondAsst", "William Wells - SA");
    activeCases.models[1].set("secondAsst", "Ryan Flanagan - SA");
    activeCases.models[2].set("secondAsst", "July Brown - SA");
    activeCases.models[3].set("secondAsst", "Fulgencio Soto - SA");

    // ORs
    activeCases.models[0].set("orRoom", "EC-2241");
    activeCases.models[1].set("orRoom", "G-211");
    activeCases.models[2].set("orRoom", "OC-3254A");
    activeCases.models[3].set("orRoom", "RAD-325B");

    // SSLQI
    // Reasons for Unavailability

    this.getUI("typeaheadField").typeahead({
        minLength: 3,
        highlight: true
      },
      {
        name: "active-case-data",
        source(query, callback) {

          // The typeahead query will have to be known globally
          typeaheadQuery = query;

          // Filters out CaseModel objects which match the query above
          const results = activeCases.filter((activeCase) => {

            let ck1 = null;
            let ck2 = null;
            let ck3 = null;
            let ck4 = null;

            // This code block returns either true or false
            if (filterTypeValue == "Specialty") {
              ck1 = activeCase.get("surgerySpecialty").toLowerCase().indexOf(query.toLowerCase()) > -1;
              return ck1;
            } else if (filterTypeValue == "Provider") {
              ck1 = activeCase.get("attendingProvider").toLowerCase().indexOf(query.toLowerCase()) > -1;
              return ck1;
            } else if(filterTypeValue == "Staff Member") {
              ck1 = activeCase.get("primarySurgeon").toLowerCase().indexOf(query.toLowerCase()) > -1;
              ck2 = activeCase.get("attendingSurgeon").toLowerCase().indexOf(query.toLowerCase()) > -1;
              ck3 = activeCase.get("firstAsst").toLowerCase().indexOf(query.toLowerCase()) > -1;
              ck4 = activeCase.get("secondAsst").toLowerCase().indexOf(query.toLowerCase()) > -1;
              return ck1 | ck2 | ck3 | ck4;
            } else if(filterTypeValue == "ORs") {
              ck1 = activeCase.get("orRoom").toLowerCase().indexOf(query.toLowerCase()) > -1;
              return ck1;
            }

          });

          let theMap = null;

          // Debug
          //console.log("Matching active cases", results);

          // Certain filter criteria require searching through more than one data item inside each case model object
          // filtered through to results above. When that happens, as with Staff Member, each data item searched for is
          // put into an temporary array, and then all the temporary arrays are lumped into one. Then all empty elements
          // in the consolidated array are gotten rid of. For filter criteria with one case model data item, its
          // processing is simpler.
          if(filterTypeValue == "Specialty")
            theMap = results.map(r => (r.get("surgerySpecialty")));
          else if(filterTypeValue == "Provider")
            theMap = results.map(r => (r.get("attendingProvider")));
          else if(filterTypeValue == "Staff Member") {

            // Need to determine which one of the filter criteria actually contains the query
            let tempMap1 = results.map(r => ( (r.get("primarySurgeon").toLowerCase().indexOf(typeaheadQuery.toLowerCase()) > -1) ? r.get("primarySurgeon") : "") );
            let tempMap2 = results.map(r => ( (r.get("attendingSurgeon").toLowerCase().indexOf(typeaheadQuery.toLowerCase()) > -1) ? r.get("attendingSurgeon") : "") );
            let tempMap3 = results.map(r => ( (r.get("firstAsst").toLowerCase().indexOf(typeaheadQuery.toLowerCase()) > -1) ? r.get("firstAsst") : "") );
            let tempMap4 = results.map(r => ( (r.get("secondAsst").toLowerCase().indexOf(typeaheadQuery.toLowerCase()) > -1) ? r.get("secondAsst") : "") );
            let tempMap = [tempMap1, tempMap2, tempMap3, tempMap4];
            theMap = [].concat.apply([], tempMap);

            // Get rid of empty array elements
            theMap = jQuery.grep(theMap, function(n, i){
              return (n !== "" && n != null);
            });

          } else if(filterTypeValue == "ORs")
            theMap = results.map(r => (r.get("orRoom")));

          callback(theMap);
        }
      });

    //$("#filterData").removeClass("tt-input");
  }
});

let hcJSONDataResponse = jQuery.parseJSON(`[
{
  "ien": "15",
  "caseCreateDate": "2016-09-14T05:00:00.000Z",
  "caseDateTime": "2016-10-14T05:00:00.000Z",
  "cancelDate": "2016-11-14T05:00:00.000Z",
  "patient": "Todd Lowry",
  "hospitalAdmissionStatus": "Admitted",
  "serviceConnected": "Hospital service",
  "generalComments": "Not SPD comments?",
  "otherProcedures": "Liver biopsy",
  "plannedPostopCare": "Physical Therapy",
  "primaryCancelReason": "N/A",
  "principalProcedure": "Amygdalohippocampectomy",
  "plannedPrincOpProcCPT": "AM1234",
  "procedureLaterality": "Additional OR preparation",
  "associatedClinic": "Santa Fe Clinic",
  "resSupCode": "RS8765",
  "anesCareTimeBlock": "4 hours",
  "princAnesthetist": "Scott Thurman",
  "anesthesiologistSupvr": "Paul Coehlo",
  "anesSuperviseCode": "AN0987",
  "anesthesiaTechnique": "Intravenous",
  "otherPostopDiags": "Fatty liver",
  "asaClass": "Class A",
  "diagnosticTherapeutic": "Therapeutic 107",
  "principalDiagnosis": "Amigdalitis",
  "specimens": "Throat culture",
  "operationIndications": "None specified",
  "operativeFindings": "None specified",
  "briefClinHistory": "5 previous incidents of severe inflamation",
  "plannedPrinDiagCode": "PPD463456",
  "location": "VAMS Surgery Center - Spokane",
  "procedureDate": "2016-10-24T05:00:00.000Z",
  "procedureStartTime": "08:00",
  "procedureEndTime": "11:00",
  "provider": "Cigna",
  "attendingProvider": "Stoppel and Associates",
  "medicalSpecialty": "Throat surgeon",
  "procedureOccurence": "Once",
  "dictatedSummary": "None specified",
  "orRoom": "OR230-5",
  "caseScheduleType": "Ledgered",
  "caseScheduleOrder": "CSO-5325432",
  "surgerySpecialty": "Ophthalmic Surgery",
  "preOpInfection": "None",
  "primarySurgeon": "Pinar Yilmaz",
  "firstAsst": "Robert Valdellon",
  "secondAsst": "Allison Welker",
  "attendingSurgeon": "Nathan Thorne",
  "otherPreopDiagnosis": "None",
  "reqAneTechnique": "Intravenous",
  "reqFrozSect": "None",
  "reqPreopXray": "No",
  "intraoperativeXrays": "Yes",
  "reqPhoto": "Yes",
  "reqBloodKind": "Yes",
  "principalPreOpDiagnosis": "Amigdalitis",
  "prinPreOpDiagICD": "AM346546",
  "requestBloodAvailability": "Yes",
  "bloodProductInfo": "Specified",
  "preAdmissionTesting": "Throat culture analysis",
  "surgeryPosition": "None specified",
  "principalPreOpICD": "PPO-ICD-32452453",
  "palliation": "Yes",
  "specialEquipment": "N/A",
  "plannedProsthImplant": "No",
  "specialSupplies": "None",
  "specialInstruments": "None needed",
  "pharmacyItems": "100 mg Vicadun",
  "plannedAdmissionStatus": "Set",
  "referringPhysician": "Leonard Capriatti"
},
{
  "ien": "12",
  "caseCreateDate": null,
  "caseDateTime": "2016-11-11T14:05:00.000Z",
  "cancelDate": null,
  "patient": null,
  "hospitalAdmissionStatus": null,
  "serviceConnected": null,
  "generalComments": null,
  "otherProcedures": null,
  "plannedPostopCare": null,
  "primaryCancelReason": null,
  "principalProcedure": "Otoplasty",
  "plannedPrincOpProcCPT": "EA887564",
  "procedureLaterality": null,
  "associatedClinic": null,
  "resSupCode": null,
  "anesCareTimeBlock": null,
  "princAnesthetist": null,
  "anesthesiologistSupvr": null,
  "anesSuperviseCode": null,
  "anesthesiaTechnique": null,
  "otherPostopDiags": null,
  "asaClass": null,
  "diagnosticTherapeutic": null,
  "principalDiagnosis": null,
  "specimens": null,
  "operationIndications": null,
  "operativeFindings": null,
  "briefClinHistory": null,
  "plannedPrinDiagCode": null,
  "location": null,
  "procedureDate": null,
  "procedureStartTime": null,
  "procedureEndTime": null,
  "provider": null,
  "attendingProvider": null,
  "medicalSpecialty": null,
  "procedureOccurence": null,
  "dictatedSummary": null,
  "orRoom": null,
  "caseScheduleType": null,
  "caseScheduleOrder": null,
  "surgerySpecialty": "Orthopaedic Surgery",
  "preOpInfection": null,
  "primarySurgeon": "Otto Kint",
  "firstAsst": null,
  "secondAsst": null,
  "attendingSurgeon": "Valerio Vega",
  "otherPreopDiagnosis": null,
  "reqAneTechnique": null,
  "reqFrozSect": null,
  "reqPreopXray": null,
  "intraoperativeXrays": null,
  "reqPhoto": null,
  "reqBloodKind": null,
  "principalPreOpDiagnosis": null,
  "prinPreOpDiagICD": null,
  "requestBloodAvailability": null,
  "bloodProductInfo": null,
  "preAdmissionTesting": null,
  "surgeryPosition": "Senior ER Staff2",
  "principalPreOpICD": null,
  "palliation": null,
  "specialEquipment": "None Needed",
  "plannedProsthImplant": null,
  "specialSupplies": null,
  "specialInstruments": null,
  "pharmacyItems": null,
  "plannedAdmissionStatus": null,
  "referringPhysician": null
},
{
  "ien": "48",
  "caseCreateDate": null,
  "caseDateTime": "2016-11-11T14:05:00.000Z",
  "cancelDate": null,
  "patient": null,
  "hospitalAdmissionStatus": null,
  "serviceConnected": null,
  "generalComments": null,
  "otherProcedures": null,
  "plannedPostopCare": null,
  "primaryCancelReason": null,
  "principalProcedure": "Rhinoplasty",
  "plannedPrincOpProcCPT": "RP32452",
  "procedureLaterality": null,
  "associatedClinic": null,
  "resSupCode": null,
  "anesCareTimeBlock": null,
  "princAnesthetist": null,
  "anesthesiologistSupvr": null,
  "anesSuperviseCode": null,
  "anesthesiaTechnique": null,
  "otherPostopDiags": null,
  "asaClass": null,
  "diagnosticTherapeutic": null,
  "principalDiagnosis": null,
  "specimens": null,
  "operationIndications": null,
  "operativeFindings": null,
  "briefClinHistory": null,
  "plannedPrinDiagCode": null,
  "location": null,
  "procedureDate": null,
  "procedureStartTime": null,
  "procedureEndTime": null,
  "provider": null,
  "attendingProvider": null,
  "medicalSpecialty": null,
  "procedureOccurence": null,
  "dictatedSummary": null,
  "orRoom": null,
  "caseScheduleType": null,
  "caseScheduleOrder": null,
  "surgerySpecialty": "Neurological Surgery",
  "preOpInfection": null,
  "primarySurgeon": "Olajide Ochefu",
  "firstAsst": null,
  "secondAsst": null,
  "attendingSurgeon": "Wilson Martinez",
  "otherPreopDiagnosis": null,
  "reqAneTechnique": null,
  "reqFrozSect": null,
  "reqPreopXray": null,
  "intraoperativeXrays": null,
  "reqPhoto": null,
  "reqBloodKind": null,
  "principalPreOpDiagnosis": null,
  "prinPreOpDiagICD": null,
  "requestBloodAvailability": null,
  "bloodProductInfo": null,
  "preAdmissionTesting": null,
  "surgeryPosition": "Senior ER Staff3",
  "principalPreOpICD": null,
  "palliation": null,
  "specialEquipment": "Pulse Oximeter",
  "plannedProsthImplant": null,
  "specialSupplies": null,
  "specialInstruments": null,
  "pharmacyItems": null,
  "plannedAdmissionStatus": null,
  "referringPhysician": null
},
{
  "ien": "47",
  "caseCreateDate": null,
  "caseDateTime": "2016-11-11T14:05:00.000Z",
  "cancelDate": null,
  "patient": null,
  "hospitalAdmissionStatus": null,
  "serviceConnected": null,
  "generalComments": null,
  "otherProcedures": null,
  "plannedPostopCare": null,
  "primaryCancelReason": null,
  "principalProcedure": "Tonsillectomy",
  "plannedPrincOpProcCPT": "TS353245",
  "procedureLaterality": null,
  "associatedClinic": null,
  "resSupCode": null,
  "anesCareTimeBlock": null,
  "princAnesthetist": null,
  "anesthesiologistSupvr": null,
  "anesSuperviseCode": null,
  "anesthesiaTechnique": null,
  "otherPostopDiags": null,
  "asaClass": null,
  "diagnosticTherapeutic": null,
  "principalDiagnosis": null,
  "specimens": null,
  "operationIndications": null,
  "operativeFindings": null,
  "briefClinHistory": null,
  "plannedPrinDiagCode": null,
  "location": null,
  "procedureDate": null,
  "procedureStartTime": null,
  "procedureEndTime": null,
  "provider": null,
  "attendingProvider": null,
  "medicalSpecialty": null,
  "procedureOccurence": null,
  "dictatedSummary": null,
  "orRoom": null,
  "caseScheduleType": null,
  "caseScheduleOrder": null,
  "surgerySpecialty": "Thoracic Surgery",
  "preOpInfection": null,
  "primarySurgeon": "Srikanth Krishnavarapu",
  "firstAsst": null,
  "secondAsst": null,
  "attendingSurgeon": "Grace Kim",
  "otherPreopDiagnosis": null,
  "reqAneTechnique": null,
  "reqFrozSect": null,
  "reqPreopXray": null,
  "intraoperativeXrays": null,
  "reqPhoto": null,
  "reqBloodKind": null,
  "principalPreOpDiagnosis": null,
  "prinPreOpDiagICD": null,
  "requestBloodAvailability": null,
  "bloodProductInfo": null,
  "preAdmissionTesting": null,
  "surgeryPosition": "Senior ER Staff4",
  "principalPreOpICD": null,
  "palliation": null,
  "specialEquipment": "Doppler",
  "plannedProsthImplant": null,
  "specialSupplies": null,
  "specialInstruments": null,
  "pharmacyItems": null,
  "plannedAdmissionStatus": null,
  "referringPhysician": null
},
 {
 "ien": "75",
 "caseCreateDate": "2016-09-14T05:00:00.000Z",
 "caseDateTime": "2016-10-14T05:00:00.000Z",
 "cancelDate": "2016-11-14T05:00:00.000Z",
 "patient": "Todd Lowry",
 "hospitalAdmissionStatus": "Admitted",
 "serviceConnected": "Hospital service",
 "generalComments": "Not SPD comments?",
 "otherProcedures": "Liver biopsy",
 "plannedPostopCare": "Physical Therapy",
 "primaryCancelReason": "N/A",
 "principalProcedure": "Ventriculostomy",
 "plannedPrincOpProcCPT": "AM1234",
 "procedureLaterality": "Additional OR preparation",
 "associatedClinic": "Santa Fe Clinic",
 "resSupCode": "RS8765",
 "anesCareTimeBlock": "4 hours",
 "princAnesthetist": "Scott Thurman",
 "anesthesiologistSupvr": "Paul Coehlo",
 "anesSuperviseCode": "AN0987",
 "anesthesiaTechnique": "Intravenous",
 "otherPostopDiags": "Fatty liver",
 "asaClass": "Class A",
 "diagnosticTherapeutic": "Therapeutic 107",
 "principalDiagnosis": "Amigdalitis",
 "specimens": "Throat culture",
 "operationIndications": "None specified",
 "operativeFindings": "None specified",
 "briefClinHistory": "5 previous incidents of severe inflamation",
 "plannedPrinDiagCode": "PPD463456",
 "location": "VAMS Surgery Center - Spokane",
 "procedureDate": "2016-10-24T05:00:00.000Z",
 "procedureStartTime": "08:00",
 "procedureEndTime": "11:00",
 "provider": "Cigna",
 "attendingProvider": "Stoppel and Associates",
 "medicalSpecialty": "Throat surgeon",
 "procedureOccurence": "Once",
 "dictatedSummary": "None specified",
 "orRoom": "OR230-5",
 "caseScheduleType": "Ledgered",
 "caseScheduleOrder": "CSO-5325432",
 "surgerySpecialty": "Obstetrics and Gynecology",
 "preOpInfection": "None",
 "primarySurgeon": "Selma Dyer",
 "firstAsst": "Robert Valdellon",
 "secondAsst": "Allison Welker",
 "attendingSurgeon": "Nathan Thorne",
 "otherPreopDiagnosis": "None",
 "reqAneTechnique": "Intravenous",
 "reqFrozSect": "None",
 "reqPreopXray": "No",
 "intraoperativeXrays": "Yes",
 "reqPhoto": "Yes",
 "reqBloodKind": "Yes",
 "principalPreOpDiagnosis": "Amigdalitis",
 "prinPreOpDiagICD": "AM346546",
 "requestBloodAvailability": "Yes",
 "bloodProductInfo": "Specified",
 "preAdmissionTesting": "Throat culture analysis",
 "surgeryPosition": "None specified",
 "principalPreOpICD": "PPO-ICD-32452453",
 "palliation": "Yes",
 "specialEquipment": "N/A",
 "plannedProsthImplant": "No",
 "specialSupplies": "None",
 "specialInstruments": "None needed",
 "pharmacyItems": "100 mg Vicadun",
 "plannedAdmissionStatus": "Set",
 "referringPhysician": "Leonard Capriatti"
 },
 {
 "ien": "99",
 "caseCreateDate": "2016-09-14T05:00:00.000Z",
 "caseDateTime": "2016-10-14T05:00:00.000Z",
 "cancelDate": "2016-11-14T05:00:00.000Z",
 "patient": "Todd Lowry",
 "hospitalAdmissionStatus": "Admitted",
 "serviceConnected": "Hospital service",
 "generalComments": "Not SPD comments?",
 "otherProcedures": "Liver biopsy",
 "plannedPostopCare": "Physical Therapy",
 "primaryCancelReason": "N/A",
 "principalProcedure": "Corneal transplantation",
 "plannedPrincOpProcCPT": "AM1234",
 "procedureLaterality": "Additional OR preparation",
 "associatedClinic": "Santa Fe Clinic",
 "resSupCode": "RS8765",
 "anesCareTimeBlock": "4 hours",
 "princAnesthetist": "Scott Thurman",
 "anesthesiologistSupvr": "Paul Coehlo",
 "anesSuperviseCode": "AN0987",
 "anesthesiaTechnique": "Intravenous",
 "otherPostopDiags": "Fatty liver",
 "asaClass": "Class A",
 "diagnosticTherapeutic": "Therapeutic 107",
 "principalDiagnosis": "Amigdalitis",
 "specimens": "Throat culture",
 "operationIndications": "None specified",
 "operativeFindings": "None specified",
 "briefClinHistory": "5 previous incidents of severe inflamation",
 "plannedPrinDiagCode": "PPD463456",
 "location": "VAMS Surgery Center - Spokane",
 "procedureDate": "2016-10-24T05:00:00.000Z",
 "procedureStartTime": "08:00",
 "procedureEndTime": "11:00",
 "provider": "Cigna",
 "attendingProvider": "Stoppel and Associates",
 "medicalSpecialty": "Throat surgeon",
 "procedureOccurence": "Once",
 "dictatedSummary": "None specified",
 "orRoom": "OR230-5",
 "caseScheduleType": "Ledgered",
 "caseScheduleOrder": "CSO-5325432",
 "surgerySpecialty": "Oral and Maxillofacial Surgery",
 "preOpInfection": "None",
 "primarySurgeon": "Selma Dyer",
 "firstAsst": "Robert Valdellon",
 "secondAsst": "Allison Welker",
 "attendingSurgeon": "Nathan Thorne",
 "otherPreopDiagnosis": "None",
 "reqAneTechnique": "Intravenous",
 "reqFrozSect": "None",
 "reqPreopXray": "No",
 "intraoperativeXrays": "Yes",
 "reqPhoto": "Yes",
 "reqBloodKind": "Yes",
 "principalPreOpDiagnosis": "Amigdalitis",
 "prinPreOpDiagICD": "AM346546",
 "requestBloodAvailability": "Yes",
 "bloodProductInfo": "Specified",
 "preAdmissionTesting": "Throat culture analysis",
 "surgeryPosition": "None specified",
 "principalPreOpICD": "PPO-ICD-32452453",
 "palliation": "Yes",
 "specialEquipment": "N/A",
 "plannedProsthImplant": "No",
 "specialSupplies": "None",
 "specialInstruments": "None needed",
 "pharmacyItems": "100 mg Vicadun",
 "plannedAdmissionStatus": "Set",
 "referringPhysician": "Leonard Capriatti"
 }
]`);

/*
 {
 "ien": "75",
 "caseCreateDate": "2016-09-14T05:00:00.000Z",
 "caseDateTime": "2016-10-14T05:00:00.000Z",
 "cancelDate": "2016-11-14T05:00:00.000Z",
 "patient": "Todd Lowry",
 "hospitalAdmissionStatus": "Admitted",
 "serviceConnected": "Hospital service",
 "generalComments": "Not SPD comments?",
 "otherProcedures": "Liver biopsy",
 "plannedPostopCare": "Physical Therapy",
 "primaryCancelReason": "N/A",
 "principalProcedure": "Ventriculostomy",
 "plannedPrincOpProcCPT": "AM1234",
 "procedureLaterality": "Additional OR preparation",
 "associatedClinic": "Santa Fe Clinic",
 "resSupCode": "RS8765",
 "anesCareTimeBlock": "4 hours",
 "princAnesthetist": "Scott Thurman",
 "anesthesiologistSupvr": "Paul Coehlo",
 "anesSuperviseCode": "AN0987",
 "anesthesiaTechnique": "Intravenous",
 "otherPostopDiags": "Fatty liver",
 "asaClass": "Class A",
 "diagnosticTherapeutic": "Therapeutic 107",
 "principalDiagnosis": "Amigdalitis",
 "specimens": "Throat culture",
 "operationIndications": "None specified",
 "operativeFindings": "None specified",
 "briefClinHistory": "5 previous incidents of severe inflamation",
 "plannedPrinDiagCode": "PPD463456",
 "location": "VAMS Surgery Center - Spokane",
 "procedureDate": "2016-10-24T05:00:00.000Z",
 "procedureStartTime": "08:00",
 "procedureEndTime": "11:00",
 "provider": "Cigna",
 "attendingProvider": "Stoppel and Associates",
 "medicalSpecialty": "Throat surgeon",
 "procedureOccurence": "Once",
 "dictatedSummary": "None specified",
 "orRoom": "OR230-5",
 "caseScheduleType": "Ledgered",
 "caseScheduleOrder": "CSO-5325432",
 "surgerySpecialty": "ENT",
 "preOpInfection": "None",
 "primarySurgeon": "Selma Dyer",
 "firstAsst": "Robert Valdellon",
 "secondAsst": "Allison Welker",
 "attendingSurgeon": "Nathan Thorne",
 "otherPreopDiagnosis": "None",
 "reqAneTechnique": "Intravenous",
 "reqFrozSect": "None",
 "reqPreopXray": "No",
 "intraoperativeXrays": "Yes",
 "reqPhoto": "Yes",
 "reqBloodKind": "Yes",
 "principalPreOpDiagnosis": "Amigdalitis",
 "prinPreOpDiagICD": "AM346546",
 "requestBloodAvailability": "Yes",
 "bloodProductInfo": "Specified",
 "preAdmissionTesting": "Throat culture analysis",
 "surgeryPosition": "None specified",
 "principalPreOpICD": "PPO-ICD-32452453",
 "palliation": "Yes",
 "specialEquipment": "N/A",
 "plannedProsthImplant": "No",
 "specialSupplies": "None",
 "specialInstruments": "None needed",
 "pharmacyItems": "100 mg Vicadun",
 "plannedAdmissionStatus": "Set",
 "referringPhysician": "Leonard Capriatti"
 },
 {
 "ien": "99",
 "caseCreateDate": "2016-09-14T05:00:00.000Z",
 "caseDateTime": "2016-10-14T05:00:00.000Z",
 "cancelDate": "2016-11-14T05:00:00.000Z",
 "patient": "Todd Lowry",
 "hospitalAdmissionStatus": "Admitted",
 "serviceConnected": "Hospital service",
 "generalComments": "Not SPD comments?",
 "otherProcedures": "Liver biopsy",
 "plannedPostopCare": "Physical Therapy",
 "primaryCancelReason": "N/A",
 "principalProcedure": "Corneal transplantation",
 "plannedPrincOpProcCPT": "AM1234",
 "procedureLaterality": "Additional OR preparation",
 "associatedClinic": "Santa Fe Clinic",
 "resSupCode": "RS8765",
 "anesCareTimeBlock": "4 hours",
 "princAnesthetist": "Scott Thurman",
 "anesthesiologistSupvr": "Paul Coehlo",
 "anesSuperviseCode": "AN0987",
 "anesthesiaTechnique": "Intravenous",
 "otherPostopDiags": "Fatty liver",
 "asaClass": "Class A",
 "diagnosticTherapeutic": "Therapeutic 107",
 "principalDiagnosis": "Amigdalitis",
 "specimens": "Throat culture",
 "operationIndications": "None specified",
 "operativeFindings": "None specified",
 "briefClinHistory": "5 previous incidents of severe inflamation",
 "plannedPrinDiagCode": "PPD463456",
 "location": "VAMS Surgery Center - Spokane",
 "procedureDate": "2016-10-24T05:00:00.000Z",
 "procedureStartTime": "08:00",
 "procedureEndTime": "11:00",
 "provider": "Cigna",
 "attendingProvider": "Stoppel and Associates",
 "medicalSpecialty": "Throat surgeon",
 "procedureOccurence": "Once",
 "dictatedSummary": "None specified",
 "orRoom": "OR230-5",
 "caseScheduleType": "Ledgered",
 "caseScheduleOrder": "CSO-5325432",
 "surgerySpecialty": "ENT",
 "preOpInfection": "None",
 "primarySurgeon": "Selma Dyer",
 "firstAsst": "Robert Valdellon",
 "secondAsst": "Allison Welker",
 "attendingSurgeon": "Nathan Thorne",
 "otherPreopDiagnosis": "None",
 "reqAneTechnique": "Intravenous",
 "reqFrozSect": "None",
 "reqPreopXray": "No",
 "intraoperativeXrays": "Yes",
 "reqPhoto": "Yes",
 "reqBloodKind": "Yes",
 "principalPreOpDiagnosis": "Amigdalitis",
 "prinPreOpDiagICD": "AM346546",
 "requestBloodAvailability": "Yes",
 "bloodProductInfo": "Specified",
 "preAdmissionTesting": "Throat culture analysis",
 "surgeryPosition": "None specified",
 "principalPreOpICD": "PPO-ICD-32452453",
 "palliation": "Yes",
 "specialEquipment": "N/A",
 "plannedProsthImplant": "No",
 "specialSupplies": "None",
 "specialInstruments": "None needed",
 "pharmacyItems": "100 mg Vicadun",
 "plannedAdmissionStatus": "Set",
 "referringPhysician": "Leonard Capriatti"
 }
*/
