const mn    = require("backbone.marionette");
const Radio = require("backbone.radio");
const SelectCaseView = require("../../sel_case/view");
const SelectPatientView = require("../../sel_patient/view");
const NAView = require("../na_placeholder/view");


module.exports = mn.View.extend({
	template: require("./template.hbs"),

	initialize() {
		// Collect relevant data from various Radio channels
		Object.assign(this.options, {
			user: Radio.request("auth", "user"),
			facility: Radio.request("store", "activeFacility"),
			patient: Radio.request("store", "activePatient"),
			activeCase: Radio.request("store", "activeCase")
		});
	},

	templateContext() {
		const user = this.getOption("user");
		const facility = this.getOption("facility");
		const patient = this.getOption("patient");


/****************** TEMP PATCH ****************/
		// Can't use "case" because it's a reserved word
		const activeCase = undefined;
		const ERRactiveCase = this.getOption("activeCase");

		// For some reason activeCase doesn't have the toJSON function so to avoid error just commenting out for now.
/******************* TEMP PATCH ****************/

		console.log("rendering", {
			user: user ? user.toJSON() : undefined,
			facility: facility ? facility.toJSON() : undefined,
			patient: patient ? patient.toJSON() : undefined,
			activeCase: activeCase ? activeCase.toJSON() : undefined
		});

		return {
			user: user ? user.toJSON() : undefined,
			facility: facility ? facility.toJSON() : undefined,
			patient: patient ? patient.toJSON() : undefined,
			activeCase: activeCase ? activeCase.toJSON() : undefined
		};
	},

	triggers: {
		"click .js-select-case":        "select:case",
		"click .js-select-SML-Patient": "select:smlPatient",
		"click .js-select-SML-Cases":   "select:smlCases",
		"click .js-select-SML-SSLQI":   "select:smlSslqi",
		"click .js-select-SML-ORs":     "select:smlOperatingRooms",
		"click .js-select-SML-Dates":   "select:smlDates"
	},

	onAttach() {
		// Backbone event handler
		// Listento - the model defined in the "auth" radio channel
		// for the "user:authenticate" event (which is triggered in the globalAPI/Auth.js module)
		// and call the "handleLogin" method (below)
		// using the "this" scope.
		this.listenTo(Radio.channel("auth"), "user:authenticate", this.handleLogin, this);

		this.listenTo(Radio.channel("store"), {
			"change:activeFacility": this.updateFacility,
			"change:activePatient": this.updatePatient,
			"change:activeCase": this.updateCase
		}, this);
	},

	onBeforeDestroy() {
		this.stopListening(Radio.channel("auth"));
		this.stopListening(Radio.channel("store"));
	},

	handleLogin(user) {
		Object.assign(this.options, { user });
		this.render();
	},

	updateFacility(facility) {
		Object.assign(this.options, { facility });
		this.render();
	},

	updatePatient(patient) {
		Object.assign(this.options, { patient });
		this.render();
	},

	updateCase(activeCase) {
		Object.assign(this.options, { activeCase: activeCase });
		this.render();
	},

	onSelectCase() {
		Radio.request("root", "modal", { view: new SelectCaseView() });
	},

	onSelectSmlPatient() {
		Radio.request("root", "modal", { view: new SelectPatientView() });
	},

	onSelectSmlCases() {
		Radio.request("root", "modal", { view: new SelectCaseView() });
	},
	onSelectSmlSslqi() { // pass the type of the selected item (or any other data we want to show up) to the view
		Radio.request("root", "modal", { view: new NAView({"type": "SSLQI"}) });
	},
	onSelectSmlOperatingRooms() {
		Radio.request("root", "modal", { view: new NAView({"type": "Operating Rooms"}) });
	},
	onSelectSmlDates() {
		Radio.request("root", "modal", { view: new NAView({"type": "Dates"}) });
	}
});
