const Marionette  = require("backbone.marionette");
const Radio       = require("backbone.radio");
const HeaderView  = require("../header/view");
const FooterView  = require("../footer/view");
const SidebarView = require("../sidebar/view");
const ModalView   = require("../../messaging/modal/view");

module.exports = Marionette.View.extend({
	initialize() {
		this._channel = Radio.channel("root");
	},

	template: require("./template.hbs"),

	regions: {
		messaging: {
			el: "#r-messaging"
		},
		header: {
			el: "#r-header",
			replaceElement: true
		},
		footer: {
			el: "#footer"
		},
		sidebar: {
			el: "#r-sidebar"
		},
		body: {
			el: "#r-body"
		}
	},

	onRender() {
		this.showChildView("header", new HeaderView());
		this.showChildView("footer", new FooterView());
		this.showChildView("sidebar", new SidebarView());
	},

	onAttach() {
		this._channel.reply({
			body: view => this.showChildView("body", view),
			modal: opts => this.showModal(opts),
			"close:modal": () => this.hideModal()
		}, this);
	},

	onBeforeDestroy() {
		this._channel.stopReplying("body modal");
	},

	showModal(opts) {
		// Before showing a new modal, make sure any existing ones are hidden.
		return this.hideModal().then(() => {
			// Show our new modal
			const modal = new ModalView(opts);
			this.showChildView("messaging", modal);
		});
	},

	hideModal() {
		const modal = this.getChildView("messaging");

		// If no modal currently shown, resolve immediately
		if (!modal) { return Promise.resolve(); }

		// If there's a modal displayed, wait for it to finish
		// animating before resolving.
		return new Promise((resolve) => {
			modal.once("destroy", resolve);
			modal.triggerMethod("close");
		});
	}
});
