const Marionette = require("backbone.marionette");
const CaseCollection = require("../../entities/case/collection");

module.exports = Marionette.View.extend({
  id: 'calendar',
  template: false,

  onAttach() {
	// Basically what you were doing in your mediateCasetoCalendarEvent
	// function only making use of the collection.map method
	const calendarData = 
	this.collection.map(
		aCase => ({
			title: aCase.get('principalProcedure'),
			start: aCase.get('dateOfOperation'),
		})
	);

	this.$el.fullCalendar({ events: calendarData });
  }
});
