const Sciatic = require("backbone.sciatic");
const Radio = require("backbone.radio");
const CaseCollection = require("../../entities/case/collection");
const authHeaders = require('../../utils/authHeaders');
const { auth } = require('../../utils/mixins');
const CalendarView = require("./view");

module.exports = Sciatic.Route.extend({
  filters: [auth],

	fetch(routeData) {
		routeData.cases = new CaseCollection();
		return routeData.cases.fetch(authHeaders());
	},

	show(routeData) {
		const calendarView = new CalendarView({ collection: routeData.cases });
		Radio.request('root', 'body', calendarView);
	}
});
