"use strict";

const $        = require("jquery");
const _        = require("lodash");
const Backbone = require("backbone");
const hbs = require("hbsfy/runtime");

// Expose globals
global.$ = global.jQuery = $;
global._ = _;
global.Backbone = Backbone;

// Import Backbone plugins
require("backbone.marionette");
require("backbone.intercept");
require("backbone.sciatic");
require("marionette.stateview");

// Import Bootstrap scripts
require("bootstrap/dist/js/bootstrap");

require("jquery/dist/jquery");
/* require("mdbootstrap/js/tether"); */
/* require("mdbootstrap/js/mdb"); */
require("moment/moment");
require("fullcalendar/dist/fullcalendar.min");
require("typeahead.js");

// Register hbs helpers
const helpers = require("./utils/hbs-helpers");
_.each(helpers, (fn, name) => hbs.registerHelper(name, (...args) => fn(...args)));

// Start up the application
const App = require("./app");
const app = new App();
app.start();
