const mn = require("backbone.marionette");

module.exports = mn.Object.extend({
	channelName: "store",

	initialize() {
		this.items = new Map();
	},

	radioRequests: {
		"get": "getItem",
		"set": "setItem",
		"clear": "clearItem"
	},

	/**
	 * Retrieves an item from the global store
	 *
	 * @param name {String}
	 * @returns {*}
	 */
	getItem(name) {
		return this.items.get(name);
	},

	/**
	 * Sets an item to the global store, clearing any old values first
	 *
	 * @param name {String}
	 * @param item {*}
	 * @returns {*}
	 */
	setItem(name, item) {
		this.clearItem(name);
		this.items.set(name, item);

		this._channel.trigger(`change:${name}`, item);

		return item;
	},

	/**
	 * Removes an item from the global store
	 *
	 * @param name {String}
	 * @returns {boolean}
	 */
	clearItem(name) {
		this._channel.trigger(`change:${name}`);
		return this.items.delete(name);
	}
});
