const $                 = require("jquery");
const Marionette        = require("backbone.marionette");
const API               = require("../api");
const Radio             = require("backbone.radio");
const AuthenticateModel = require("../entities/login/model");
const FacilityModel     = require("../entities/facilities/model");
const storage           = require("../utils/storage");

module.exports = Marionette.Object.extend({
	channelName: "auth",

	initialize() {
		// If the user is still logged-in we want to make their model
		// available right away

		if (storage.getItem("access_token")) {
			this.currentUser = new AuthenticateModel({
				access_token: storage.getItem("access_token"),
				firstname: storage.getItem("firstname"),
				lastname: storage.getItem("lastname"),
				roles: storage.getItem("roles")
			});
		}
	},

	/**
	 *	The requests for this channel...
	 **/
	radioRequests() {
		return {
			"login": "loginFnc",
			"user": () => this.currentUser		// "Fat" arrow function from ECMAScript 6 that returns the currentUser from this scope.
		};
	},


/*
 * Called by the radio request in the handleLoginClick event handler in the modules\login\view
 * The radio.request passes the following parameters: channel, requestID, and data
 */
	loginFnc(data) {
		console.log("globalAPI - Auth Object, loginFnc fcn - ", data);
		// do a simple jquery post of the data from the form to authenticate
		return $.post(API.getURL("Authenticate"), data)
			.then((authData) => {
				const authModel = new AuthenticateModel(authData);
				// Put access token and the login info into local storage for later retrieval
				storage.clear();
				authModel.saveToLocalStorage();

				storage.setItem("stationID", data.stationID);
				storage.setItem("facilityName", data.facilityName);

				// Trigger global event
				this.currentUser = authModel;
				this._channel.trigger("user:authenticate", authModel);

				return authModel;
			});
	}
});
