const BaseModel = require("../../base/model");
const API       = require("../../../api");
const storage   = require("../../../utils/storage");

module.exports = BaseModel.extend({
	urlRoot: API.getURL("PatientId"),
	defaults: {
		"name": null,
		"gender": null,
		"dob": null,
		"ssn": null,
		"age": null,
		"localPid": null
	},


	saveToLocalStorage() {
		storage.setItem("PatientName", this.get('name'));
		storage.setItem("PatientGender", this.get('gender'));
		storage.setItem("PatientDOB", this.get('dob'));
		storage.setItem("PatientSSN", this.get('ssn'));
		storage.setItem("PatientAGE", this.get('age'));
		storage.setItem("PatientLocalPid", this.get('localPid'));
	}
});
