const BaseModel = require("../../base/model");
const ComputedFields = require("backbone-computedfields");
const API       = require("../../../api");
const storage   = require("../../../utils/storage");

module.exports = BaseModel.extend({
  urlRoot: API.getURL("PatientAll"),
  defaults: {
  	"PatientAllModel": "",
	"dfn": "",
	"name": "",
	"gender": "",
	"dob": "",
	"age": "",
	"ssn": "",
	"birthCity": "",
	"birthState": "",
	"provider": "",
	"roomBed": "",
	"currentRoomBed": "",
	"addrStreet1": "",
	"addrStreet2": "",
	"addrStreet3": "",
	"addrCity": "",
	"addrState": "",
	"addrZip": "",
	"addrCounty": "",
	"addrProvince": "",
	"addCountry": "",
	"addrForeignPostCode": "",
	"addrZipExt": "",
	"resPhoneNum": "",
	"workPhonNum": "",
	"email": "",
	"kName": "",
	"kRelationship": "",
	"kAddressPatientAddress": "",
	"kStreet1": "",
	"kStreet2": "",
	"kStreet3": "",
	"kCity": "",
	"kState": "",
	"kZip": "",
	"kPhone": "",
	"scYesNo": "",
	"scAwardDate": ""
  },


	initialize: function () {
		this.computedFields = new Backbone.ComputedFields(this);
	},

	computed: {
		lastFive: {
			depends: ['name', 'dfn'],
			get: function (fields) {
				return this.fakeLast5(fields.name);
			},
			set:function(fields) {
				fields.lastFive = this.fakeLast5(fields.name);
			}
		}
	},

	fakeLast5: function(name) {
		let last5 = "";
		switch(name) {
			case "BENSON,GEORGE":
				last5 = "B0500";
				break;

			case "FIVEHUNDRED,PATIENT":
				last5 = "F0500";
				break;

			case "FIVEHUNDREDFIVE,PATIENT":
				last5 = "F0505";
				break;

			case "FIVEHUNDREDFIVE2,PATIENT":
				last5 = "F0552";
				break;

			case "FIVEHUNDREDFOUR,PATIENT":
				last5 = "F0504";
				break;

			case "FIVEHUNDREDONE,PATIENT":
				last5 = "F0501";
				break;

			case "FIVEHUNDREDSEVEN,PATIENT":
				last5 = "F0507";
				break;

			case "FIVEHUNDREDSIX,PATIENT":
				last5 = "F0506";
				break;

			case "FIVEHUNDREDTHREE,PATIENT":
				last5 = "F0503";
				break;

			case "FIVEHUNDREDTWO,PATIENT":
				last5 = "F0502";
				break;

			case "WITHERS,BILL":
				last5 = "W0500";
				break;

			case "ZZ PATIENT,TEST ONE":
				last5 = "Z0501";
				break;

			case "ZZ PATIENT,TEST THREE":
				last5 = "Z0503";
				break;

			case "ZZ PATIENT,TEST TWO":
				last5 = "Z0502";
				break;
		}
		return last5;
	},


  saveToLocalStorage: function() {
	storage.setItem("PatientName", this.get('name'));
	storage.setItem("PatientGender", this.get('gender'));
	storage.setItem("PatientDOB", this.get('dob'));
	storage.setItem("PatientSSN", this.get('ssn'));
	storage.setItem("PatientAGE", this.get('age'));
	storage.setItem("PatientLocalPid", this.get('localPid'));
  }
});
