const BaseModel = require("../base/model");
const API       = require("../../api");
const storage   = require("../../utils/storage");


module.exports = BaseModel.extend({
	urlRoot: API.getURL("Authenticate"),
	defaults: {
		"firstname": "",
		"lastname": "",
		"roles": [],
		"success": null,
		"message": null,
		"token": null
	},

	saveToLocalStorage() {
		storage.setItem("access_token", this.get("token"));
		storage.setItem("firstname", this.get("firstname"));
		storage.setItem("lastname", this.get("lastname"));
		storage.setItem("roles", this.get("roles"));
	}
});
