const BaseModel = require("../base/model");
const API      = require("../../api");

module.exports = BaseModel.extend({
	idAttribute: "ien",
	urlRoot: API.getURL("CaseByID"),

	defaults: {
		ien: null,
		caseCreateDate: null,
		caseDateTime: null,
		cancelDate: null,
		patient: null,
		hospitalAdmissionStatus: null,
		serviceConnected: null,
		generalComments: null,
		otherProcedures: null,
		plannedPostopCare: null,
		primaryCancelReason: null,
		principalProcedure: "",
		plannedPrincOpProcCPT: null,
		procedureLaterality: null,
		associatedClinic: null,
		resSupCode: null,
		anesCareTimeBlock: null,
		princAnesthetist: null,
		anesthesiologistSupvr: null,
		anesSuperviseCode: null,
		anesthesiaTechnique: null,
		otherPostopDiags: null,
		asaClass: null,
		diagnosticTherapeutic: null,
		principalDiagnosis: null,
		specimens: null,
		operationIndications: null,
		operativeFindings: null,
		briefClinHistory: null,
		plannedPrinDiagCode: null,
		location: null,
		procedureDate: null,
		procedureStartTime: null,
		procedureEndTime: null,
		provider: null,
		attendingProvider: null,
		medicalSpecialty: null,
		procedureOccurence: null,
		dictatedSummary: null,
		orRoom: null,
		caseScheduleType: null,
		caseScheduleOrder: null,
		surgerySpecialty: null,
		preOpInfection: null,
		primarySurgeon: [],
		firstAsst: null,
		secondAsst: null,
		attendingSurgeon: null,
		otherPreopDiagnosis: null,
		reqAneTechnique: null,
		reqFrozSect: null,
		reqPreopXray: null,
		intraoperativeXrays: null,
		reqPhoto: null,
		reqBloodKind: null,
		principalPreOpDiagnosis: null,
		prinPreOpDiagICD: null,
		requestBloodAvailability: null,
		bloodProductInfo: null,
		preAdmissionTesting: null,
		surgeryPosition: null,
		principalPreOpICD: null,
		palliation: null,
		specialEquipment: null,
		plannedProsthImplant: null,
		specialSupplies: null,
		specialInstruments: null,
		pharmacyItems: null,
		plannedAdmissionStatus: null,
		referringPhysician: null
	}
});
