const Backbone   = require("backbone");
const Marionette = require("backbone.marionette");
const Radio      = require("backbone.radio");

const Router     = require("./router");
const RootView   = require("./modules/global/root/view");
const Auth       = require("./globalAPI/Auth");
const Store      = require("./globalAPI/Store");

module.exports = Marionette.Application.extend({
	region: "#app",

/**
 * MWB - 5 Jan 2017 - Need to change app startup procedure:
 *	When starting the application if local storage has
 *		a web token, check if the token is valid. If it is then don"t force a login
 */

	onStart() {
		this.router = new Router();
		this.auth = new Auth();
		this.store = new Store();
		this.showView(new RootView());

		Radio.reply("global", "navigate", this.navigate, this);

			// Invoke routing
		Backbone.Intercept.start();
		Backbone.history.start({ pushState: true });
	},

	navigate(uri, options = { trigger: true }) {
		return this.router.navigate(uri, options);
	}
});
