"use strict";
const config = require("./env.json");

let API_Base = config.NODE_API_EXTERNAL;
console.log("ENV - ", config.NODE_ENV);
if ("develop" == config.NODE_ENV) {
	API_Base = config.NODE_API_INTERNAL;
}
console.log("API_Base - ", API_Base);

/**
 * Here's where any constants for the API and non API URL's should be going
 **/


const GenericHelpURL = "http://URL                   /pm/iehr/vista_evolution/eHMP/Help_Wiki/Wiki%20Page%20Library/Accessing%20the%20eHMP%20Application.aspx";
const APIRoutes = {

  // Base
	"API_Base": API_Base,

  // API calls below here DO NOT requre access token
	"Authenticate": "authenticate",
	"Facilities": "facilities",

  // API calls below here require access token
	"FacilitiesDetails":     "v1/facilities",

	"PatientAll": "v1/patient/all",
	"PatientLastFive": "v1/patient/five/",
	"PatientId": "v1/patient/",
	"PatientSSN": "v1/patient/ssn/",
	"PatientSurgeryDetails": "/v1/surgery/",

	"Case":            "v1/case",
	"CasesPlaceholder": "v1/cases/placeholder",
	"CaseByID":         "v1/cases/"

};


const getURL = function(apiName, p1) {
	const url = APIRoutes.API_Base + APIRoutes[apiName] + (p1 ? `/${p1}` : "");
	return url;
};

module.exports = {
	getURL: getURL,
	GenericHelpURL: GenericHelpURL
};
