"use strict";

const $ = require("../../config.js");

const sStyles      = $.config.src + "/styles";
const sStylesFiles = sStyles + "/app.less";
const wStylesFiles = sStyles + "/**/*";
const dStylesFiles = $.config.dest;
const sStylesSettings = {
	paths: [
		sStyles + "/",
		$.nodeModules + "/"
	]
};

const stylesFnc = function() {
	console.log("------------------ Reloading Styles ------------------");
	let combined = $.combiner.obj([
		$.gulp.src(sStylesFiles),
		$.sourcemaps.init(),
		$.less(sStylesSettings),
		$.sourcemaps.write(),
		// postcss([ autoprefixer({ browsers: ["last 2 versions"] }) ]),
		$.gulp.dest(dStylesFiles)
	]);
	combined.on("error", console.error.bind(console));
	return combined;

};

$.gulp.task(
	"styles", 
	`Compiles all the LESS stylesheets from the ${sStylesFiles} folder into a single CSS stylesheet in the ${dStylesFiles} folder`,
	[],
	stylesFnc
);
