"use strict";

const $ = require("../../config.js");



/********************************************************************************/
const sImageFiles = $.config.src + "/images/*";
const dImageFiles = $.config.dest + "/images";

const ImageFnc = function() {
	console.log("------------------ Reloading Images ------------------");
	let combined = $.combiner.obj([
		$.gulp.src(sImageFiles),
		$.changed(dImageFiles),
		$.imagemin(),
		$.gulp.dest(dImageFiles)
	]);
	combined.on("error", console.error.bind(console));
	return combined;
};

$.gulp.task(
	"images", 
	`Copies and minimizes any images from the ${sImageFiles} folder to the ${dImageFiles} folder`,
	[],
	ImageFnc
);
