process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);
let testId;

describe('Tests the management of Template cases', function() {
    this.timeout(0);
    it('should create a new template case', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases/template/')
                .set('Authorization', token)
                .send({
                    "caseCreateDate" : new Date(),
                    "dateOfOperation" : "2017-07-10T10:50:42.389Z",
                    "principalProcedure" : "New Test Procedure",
                    "generalComments" : "Some comment should go here",
                    "plannedPostopCare" : "1 day in the hospital",
                    "plannedPrincOpProcCPT" : "CPT01"
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('object');
                    response.body.should.have.property('_id');
                    console.log(response.body._id);
                    testId = response.body._id;
                    done();
                });
        })
    });

    it('should update existing template cases for the specified id: ' + testId, function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases/template/' +testId)
                .set('Authorization', token)
                .send({
                    "dateOfOperation" : "2017-06-22T10:50:42.389Z",
                    "principalProcedure" : "New Test Procedure",
                    "generalComments" : "Some comment should go here",
                    "plannedPostopCare" : "4 days in the hospital",
                    "plannedPrincOpProcCPT" : "CPT03"
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    done();
                });
        })
    });

    it('should get a template case by a specified id: ' + testId, function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/template/' + testId)
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('object');
                    response.body.should.have.property('_id');
                    response.body.should.have.property('principalProcedure');
                    done();
                });
        })
    });

    it('should get a template case by a specified principal procedure: ', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/template/procedure/New Test Procedure')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('object');
                    response.body.should.have.property('_id');
                    response.body.should.have.property('principalProcedure');
                    done();
                });
        })
    });

    it('should delete an existing template case for the specified id: ' + testId, function(done){
        authenticate(function(token){
            "use strict";
            console.log("**TEST ID**")
            console.log(testId);
            chai.request(server)
                .delete('/v1/cases/template/' + testId)
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should get a list of all template cases', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/template')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });
});
