'use strict';
process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

describe('v1 Site', function(){

   it('should list All sites on /facilities GET', function(done){
       authenticate(function(token){
           chai.request(server)
               .get('/facilities')
               .set("Authorization", token)
               .end(function (error, response) {
                   response.should.have.status(200);
                   response.should.be.json;
                   response.body.should.be.a('array');
                   done();
               });
       })

    });

    it('should list All sites on /v1/facilities/ GET', function(done){
      authenticate(function(token){
          chai.request(server)
              .get('/v1/facilities/')
              .set("Authorization", token)
              .end(function (error, response) {
                  response.should.have.status(200);
                  response.should.be.json;
                  response.body.should.be.a('array');
                  done();
              });
      });
   });

    it('should retrieve a SINGLE site for on /v1/facilities/554 GET', function(done){
        authenticate(function(token) {
            chai.request(server)
                .get('/v1/facilities/554')
                .set("Authorization", token)
                .end(function (err, res) {
                    res.should.have.status(200);
                    res.should.be.json;
                    res.body.should.be.a('object');
                    res.body.should.have.property('_id');
                    res.body.should.have.property('facilityName');
                    res.body.should.have.property('stationID');
                    done();
                });
        });
    });

    it('should delete the specified site for /v1/facilities/554 DELETE', function(done){
        authenticate(function(token){
            chai.request(server)
                .delete('/v1/facilities/554')
                .set("Authorization", token)
                .end(function(err, res){
                    res.should.have.status(200);
                    res.should.be.json;
                    res.body.should.have.property('ok');
                    res.body.should.have.property('n');
                    done();
                });
        });
    });

    it('should create a new site with the specified values for /v1/facilities/', function(done){
        authenticate(function(token){
            chai.request(server)
                .post('/v1/facilities/')
                .set("Authorization", token)
                .send({
                    "stationID":"554",
                    "facilityName":"VA Eastern Colorado Health Care System (ECHCS) (Denver, Fort Lyon)",
                    "state":"CO",
                    "complexityLevel":"1a",
                    "visn":"19",
                    "facilitySize":"Large",
                    "ipAddress":"74.102.74.38",
                    "port":"9211"
                })
                .end(function(err, res){
                    res.should.have.status(200);
                    res.should.be.json;
                    res.body.should.be.a('object');
                    res.body.should.have.property('__v');
                    res.body.should.have.property('_id');
                    res.body.should.have.property('facilityName');
                    res.body.should.have.property('stationID');
                    res.body.should.have.property('state');
                    res.body.should.have.property('visn');
                    res.body.should.have.property('facilitySize');
                    res.body.should.have.property('complexityLevel');
                    done();
                });
        });
    });

});