process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

describe('GET detailed data for OR Room', function() {
    this.timeout(0);
    it('By room ID', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/room/or/17')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('Associated with specified case', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/room/44')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });
});
