process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);
let testId;

describe('Tests the management of system roles', function() {
    this.timeout(0);
    it('should create a new role', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/roles/')
                .set('Authorization', token)
                .send({
                    "role" : "Test Role",
                    "keys" : [ "TEST1", "TEST2", "TEST3", "TEST4"]
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('object');
                    response.body.should.have.property('_id');
                    console.log(response.body._id);
                    testId = response.body._id;
                    done();
                });
        })
    });

    it('should update existing role for the specified id: ' + testId, function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/roles/' +testId)
                .set('Authorization', token)
                .send({
                    "role" : "Test Role",
                    "keys" : [ "TEST1", "TEST2", "TEST3", "TEST5"]
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    done();
                });
        })
    });

    it('should get a role by a specified id: ' + testId, function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/roles/' + testId)
                .set('Authorization', token)
                .end(function(err,response){
                    console.log();
                    console.log(response.body);
                    console.log();
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('object');
                    response.body.should.have.property('_id');
                    response.body.should.have.property('role');
                    response.body.should.have.property('keys');
                    done();
                });
        })
    });

    it('should delete an existing role for the specified id: ' + testId, function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .delete('/v1/roles/' + testId)
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should get a list of all roles', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/roles/')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of all role names', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/roles/list/names')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of all keys', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/roles/list/keys')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });
});
