/**
 * Created by atignola on 1/19/2017.
 */
process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

describe('Tests the management of placeholder cases', function() {
    this.timeout(0);

    it('should create a new placeholder case with specified data', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases/placeholder')
                .set('Authorization', token)
                .send({
                    "hospitalAdmissionStatus": "Not admitted",
                    "principalProcedure": "Growth removal",
                    "otherProcedures": ["Wart removal", "something else"],
                    "dateOfOperation": "3/12/2017"
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });


    it('should modify the existing placeholder case with new data', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases/placeholder/949')
                .set('Authorization', token)
                .send({
                    "hospitalAdmissionStatus": "Not admitted",
                    "principalProcedure": "Growth removal",
                    "otherProcedures": ["Wart removal", "something else"],
                    "dateOfOperation": "3/12/2017"
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should get a list of placeholder cases', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/placeholder')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of placeholder cases for specified date range', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/placeholder/2017-01-01/2017-06-30')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of placeholder cases for specified year and month', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/placeholder/date/2017/01')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of placeholder cases for specified year, month, and day', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/placeholder/date/2017/01/03')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should export a list of all placeholder cases', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases/placeholder/export')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });


    it('should export a list of all placeholder cases for specified date range', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/placeholder/export/2017-01-01/2017-04-30')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });


    it('should export a list of placeholder cases for specified year/month', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/placeholder/export/date/2017/01')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });


    it('should export a list of placeholder cases specified for year/month/day', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/placeholder/export/date/2017/01/01')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should import a list of new placeholder cases', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases/placeholder/import')
                .set('Authorization', token)
                .send(
                    [
                        {
                            "dateOfOperation": "2016-11-14T05:00:00.000Z",
                            "principalProcedure": "Operation Description, Short Name"
                        },
                        {
                            "dateOfOperation": "2016-11-11T14:05:00.000Z",
                            "principalProcedure": "Operation Name"
                        },
                        {
                            "dateOfOperation": "2016-11-11T14:05:00.000Z",
                            "principalProcedure": "OPERATION REPORT"
                        },
                        {
                            "dateOfOperation": "2016-11-11T14:05:00.000Z",
                            "principalProcedure": "NURSE INTRAOPERATIVE REPORT"
                        }
                    ]
                )
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

});
