process.env.NODE_ENV = 'test';
var chai = require('chai');
var chaiHttp = require('chai-http');
var server = require('../index');
var should = chai.should();
const authenticate = require('./test_config');

chai.use(chaiHttp);

describe('GET list of Surgeries cases', function() {
    this.timeout(0);
    it('should get a case for caseId = 5', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/5')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });

    it('should get a list of requested cases for specified year and month', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/requested/date/2017/01')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should get a list of requested cases for specified year, month, and day', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .get('/v1/cases/requested/date/2017/01/03')
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    response.body.should.be.a('array');
                    done();
                });
        })
    });

    it('should cancel a case given a specified ID', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases/cancel/44')
                .send({
                    "cancelReason": "some reason",
                    "cancelComments": "need to reschedule",
                    "cancelledBy": "some_user"
                })
                .set('Authorization', token)
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });
    it('should reschedule a case for the new specified date/time', function(done){
        authenticate(function(token){
            "use strict";
            chai.request(server)
                .post('/v1/cases/reschedule/44')
                .set('Authorization', token)
                .send({
                    "procedureDate": "2017-04-01",
                    "reschDate": "2017-04-20",
                    "cancelComments": "family emergency"
                })
                .end(function(err,response){
                    response.should.have.status(200);
                    response.should.be.json;
                    done();
                });
        })
    });
});
