'use strict';
const vistaconfig = require("../../../lib/rpcvista/vistaconfig");
const vista = require("../../../lib/rpcvista/VistaJS");
const auth = require("../authenticate");
const Case = require("../../model/case");
const caseService = require("./case");

/************************************
 *        Placeholder Cases         *
 ************************************/
/**
 * Creates a new placeholder case object
 * @param loginOptions
 * @param caseData
 * @param callback
 */
exports.createPlaceholderCase = function(loginOptions, caseData, callback){

    console.log("Entering createPlaceholderCase ...");
    console.log(caseData);
    callback(null, {id: 949});
    //TODO - implement logic
    /*auth.buildConfiguration(loginOptions, function(configuration){
     vista.callRpc(
     vistaconfig.logger,
     configuration,
     '',
     [],//TODO - enter params
     function(error, result){

     });
     });*/
};

/**
 * Creates a new placeholder case object for every object in list
 * @param loginOptions
 * @param caseData - list of placeholder cases in JSON format
 * @param callback
 */
exports.createMultiplePlaceholderCases = function(loginOptions, caseData, callback){

    console.log("Entering createMultiplePlaceholderCases ...");
    console.log(caseData);

    callback(null, {id: [949, 950, 951, 952]});
    //TODO - implement logic
    /*auth.buildConfiguration(loginOptions, function(configuration){
     vista.callRpc(
     vistaconfig.logger,
     configuration,
     '',
     [],//TODO - enter params
     function(error, result){

     });
     });*/
};

/**
 * Creates a new placeholder case object
 * @param loginOptions
 * @param caseData
 * @param callback
 */
exports.editPlaceholderCase = function(loginOptions, caseData, callback){

    console.log("Entering editPlaceholderCase ...");
    console.log(caseData);
    callback(null, caseData);
    //TODO - implement logic
    /*auth.buildConfiguration(loginOptions, function(configuration){
     vista.callRpc(
     vistaconfig.logger,
     configuration,
     '',
     [],//TODO - enter params
     function(error, result){

     });
     });*/
};

/**
 * Retrieves a list of placeholder cases
 * @param loginOptions
 * @param callback
 */
exports.findPlaceholderCases = function(loginOptions, callback) {
    //TODO - Implement method
    caseService.buildMockList(function(list){

        callback(null, list);
    });

    /*auth.buildConfiguration(loginOptions, function(configuration){
     console.log(routine);
     vista.callRpc(
     vistaconfig.logger,
     configuration,
     //TODO - specify routine call and parameters
     '',
     '',
     function(error, result){
     if(result instanceof Error || result === undefined){
     console.log('ERROR');
     callback(result, null);
     }else{
     //OR2^20^injury^3170104^24;DOCTOR,ELEVEN^^20:30^22:00
     //OR2^32^crown^3170511^93;ONE,SURGEON^^20:00^21:00

     let resultList = result.split("\r\n");
     let caseList = [];
     if (resultList instanceof Array){
     var rowSplit, surgeonSplit, vistaCase, caseStartDateTime, caseEndDateTime;
     for (var i = 0, x = resultList.length - 1; i < x; i++){
     if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
     console.log('empty row - split tail entry: ' + (i == x));
     }
     else {
     rowSplit = resultList[i].split('^');
     if (resultList != undefined){
     surgeonSplit = rowSplit[4].split(';');
     }

     caseStartDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[6].replace(':',''));
     caseEndDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[7].replace(':',''));

     vistaCase = {
     ien: rowSplit[1],
     description: rowSplit[2],
     dateOfOperation: caseStartDateTime,
     caseDuration: (caseEndDateTime - caseStartDateTime)/1000/60,
     surgeon: {
     id: surgeonSplit[0],
     name: surgeonSplit[1]
     },
     orRoom: rowSplit[0]
     };
     caseList[i] = vistaCase;
     }
     }
     }
     callback(error, caseList);
     }
     }
     );
     });*/
};

/**
 * Retrieves a list of placeholder cases
 * @param loginOptions
 * @param callback
 */
exports.findPlaceholderCasesForDateRange = function(loginOptions, beginDate, endDate, callback) {
    //TODO - Implement method
    console.log("Entering findPlaceholderCasesForDateRange ...");
    caseService.buildMockList(function(list){
        callback(null, list);
    });
    /*auth.buildConfiguration(loginOptions, function(configuration){
     console.log(routine);
     vista.callRpc(
     vistaconfig.logger,
     configuration,
     //TODO - specify routine call and parameters
     '',
     '',
     function(error, result){
     if(result instanceof Error || result === undefined){
     console.log('ERROR');
     callback(result, null);
     }else{
     //OR2^20^injury^3170104^24;DOCTOR,ELEVEN^^20:30^22:00
     //OR2^32^crown^3170511^93;ONE,SURGEON^^20:00^21:00

     let resultList = result.split("\r\n");
     let caseList = [];
     if (resultList instanceof Array){
     var rowSplit, surgeonSplit, vistaCase, caseStartDateTime, caseEndDateTime;
     for (var i = 0, x = resultList.length - 1; i < x; i++){
     if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
     console.log('empty row - split tail entry: ' + (i == x));
     }
     else {
     rowSplit = resultList[i].split('^');
     if (resultList != undefined){
     surgeonSplit = rowSplit[4].split(';');
     }

     caseStartDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[6].replace(':',''));
     caseEndDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[7].replace(':',''));

     vistaCase = {
     ien: rowSplit[1],
     description: rowSplit[2],
     dateOfOperation: caseStartDateTime,
     caseDuration: (caseEndDateTime - caseStartDateTime)/1000/60,
     surgeon: {
     id: surgeonSplit[0],
     name: surgeonSplit[1]
     },
     orRoom: rowSplit[0]
     };
     caseList[i] = vistaCase;
     }
     }
     }
     callback(error, caseList);
     }
     }
     );
     });*/
};

/**
 * Retrieves a list of placeholder cases for a specified patient
 * @param loginOptions
 * @param callback
 */
exports.findPatientPlaceholderCases = function(loginOptions, patientID, callback) {
    console.log("Entering findPatientPlaceholderCases ...");
    auth.buildConfiguration(loginOptions, function(configuration){
        vista.callRpc(
            vistaconfig.logger,
            configuration,
            'SR GET PLACE HOLDER CASES',
            patientID,
            function(error, result){
                if (error){
                    console.log("Error:" + error);
                    callback(error, null);
                }
                else if(result instanceof Error || result === undefined){
                    console.log('ERROR');
                    callback(result, null);
                }else{
                    console.log('***found placeholder cases for patient');
                    console.log(result);
                    /*
                     H1 SURGICAL SPECIALTY TEXT
                     H2 SURGICAL SPECIALTY NUMBER
                     .01  PATIENT NAME
                     1  OPERATION
                     2  DATE ENTERED ON LIST
                     3  REFERRING PHYSICIAN
                     4  COMMENTS
                     5  TENTATIVE ADMISSION DATE
                     6  TENTATIVE DATE OF OPERATION
                     16  SERVICE CONNECTED
                     17  AGENT ORANGE EXPOSURE
                     18  IONIZING RADIATION EXPOSURE
                     19  SOUTHWEST ASIA CONDITIONS
                     20  CLASSIFICATION ENTERED (Y/N)
                     21  MILITARY SEXUAL TRAUMA
                     22  HEAD AND/OR NECK CANCER
                     23  COMBAT VET
                     24  PROJ 112/SHAD
                     */

                    let resultList = result.split("\r");
                    let caseList = [];
                    if (resultList instanceof Array){
                        var rowSplit, surgeonSplit, vistaCase, caseStartDateTime, caseEndDateTime;
                        for (var i = 0, x = resultList.length - 1; i < x; i++){
                            if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
                                console.log('empty row - split tail entry: ' + (i == x));
                            }
                            else {
                                rowSplit = resultList[i].split('^');
                                if (resultList != undefined){
                                    surgeonSplit = rowSplit[4].split(';');
                                }

                                caseStartDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[6].replace(':',''));
                                caseEndDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[7].replace(':',''));

                                vistaCase = {
                                    ien: rowSplit[1],
                                    description: rowSplit[2],
                                    dateOfOperation: caseStartDateTime,
                                    caseDuration: (caseEndDateTime - caseStartDateTime)/1000/60,
                                    surgeon: {
                                        id: surgeonSplit[0],
                                        name: surgeonSplit[1]
                                    },
                                    orRoom: rowSplit[0]
                                };
                                caseList[i] = vistaCase;
                            }
                        }
                    }
                }
            }
        );
    });
};