'use strict';
const vistaconfig = require("../../../lib/rpcvista/vistaconfig");
const vista = require("../../../lib/rpcvista/VistaJS");
const auth = require("../authenticate");
const Case = require("../../model/case");
const NonOrCase = require("../../model/nonOrCase");
const RequestedCase = require("../../model/requestedCase");
const ScheduledCase = require("../../model/scheduledCase");

/********************************
 *        General Cases         *
 ********************************/
/**
 * Retrieves specific case by case id (ien)
 * @param loginOptions
 * @param caseId
 * @param callback
 */
exports.findCaseById = function(loginOptions, caseId, callback) {
    // TODO - Implement method
    let vistaCase = new RequestedCase();
    vistaCase.setData({
        "ien": caseId,
        "principalProcedure": "Operation Description",
        "dateOfOperation": "2016-11-14T05:00:00.000Z",
        "primarySurgeon": [{
            "id": "93",
            "name": "ONE,SURGEON"
        }]
    });
    callback(null, vistaCase.sanitize());
};

/**
 * Retrieves all cases
 * @param loginOptions
 * @param callback
 */
exports.findAllCases = function(loginOptions, callback){
    this.buildMockList(function(list){
        callback(null, list);
    });
    /*
    auth.buildConfiguration(loginOptions, function(configuration){
        vista.callRpc(
            vistaconfig.logger,
            configuration,
            'SR GET ALL CASES',
            function(error, result){
                if (error){
                    console.log(error);
                    callback(error, null);
                }
                else{
                    console.log("FOUND DATA");
                    console.log(result);
                    //FIXME - not currently returning data
                    //TODO - parse through data
                }
            }
        );
    });*/
}

/**
 * Cancels an existing case
 * @param loginOptions
 * @param id
 * @param data
 * @param callback
 */
exports.cancelCase = function(loginOptions, id, data, callback){
    console.log("Entering cancelCase ...");
   // Extract data
    let cancelReason = data["cancelCode"] || "";    //TODO - retrieve cancel reason from mongo
    let comments = data["cancelComments"] || "";
    let cancelDate = new Date();
    let user = data["cancelledBy"] || "";

    console.log(id);
    console.log(cancelReason);
    console.log(comments);
    console.log(cancelDate);
    console.log(user);

    // Convert date
    vista.convertToVistaDate(cancelDate);

    //TODO - implement RPC call

    callback(null, "");
};

/**
 * Reschedules a case
 * @param loginOptions
 * @param id
 * @param data
 * @param callback
 */
exports.rescheduleCase = function(loginOptions, id, data, callback){
    console.log("Entering rescheduleCase ...");
    // Extract data
    let currentProcDate = data["procedureDate"];
    let reschDate = data["reschDate"];
    let comment = data["cancelComments"];
    // TODO - Take in time parameter too

    console.log(id);
    console.log(currentProcDate);
    console.log(reschDate);
    console.log(comment);

    // Check for cancel comments
    if (comment === undefined)
    {
        // Reschedule the case
        // TODO - implement logic
    }
    else
    {
        // Create new case(requested? scheduled?) with reference to old case data
        // TODO - implement logic

        // Cancel old case and add reference to new case
        // TODO - implement logic

    }

    callback(null, "");

    /****************************************************************
     * TODO - This blocked comment is how we will have to implement
     * the code if we don't go with the checking of the cancelComments
    //Check delta of current date/time and case scheduled date/time
    // If delta < 48 hours cancel case and create new
    // If delta > 48 hours modify case data
    *****************************************************************/
};


/**
 * Retrieves a list of cases by case type for a specific time period
 * @param loginOptions
 * @param beginDate
 * @param endDate
 * @param caseType
 * @param callback
 */
exports.findCasesForDateRange = function(loginOptions, beginDate, endDate, caseType, callback) {
    //TODO - may need to handle different casetypes in different calls depending on RPC response/result
    // console.log("casetype: " + caseType);

    // Routine to call TODO - update 'REQUESTED CASES' and 'PLACEHOLDER CASES' once a routine exists
    //var routine = ((caseType === this.SCHEDULED)? 'SROSLST SCHED SURG':(caseType === this.REQUESTED ? 'REQUESTED CASES': 'PLACEHOLDER CASES'));
    var routine = 'SROSLST SCHED SURG';

    auth.buildConfiguration(loginOptions, function(configuration){
        console.log(routine);
        vista.callRpc(
            vistaconfig.logger,
            configuration,
            routine,
            [vista.convertToVistaDate(beginDate), vista.convertToVistaDate(endDate)],
            function(error, result){
                if(result instanceof Error || result === undefined){
                    console.log('ERROR');
                    callback(result, null);
                }else{
                    /*
                     OR2^20^injury^3170104^24;DOCTOR,ELEVEN^^20:30^22:00
                     OR2^32^crown^3170511^93;ONE,SURGEON^^20:00^21:00
                     */
                    let resultList = result.split("\r\n");
                    let caseList = [];
                    if (resultList instanceof Array){
                        var rowSplit, surgeonSplit, caseStartDateTime, caseEndDateTime;
                        var vistaCase;
                        for (var i = 0, x = resultList.length - 1; i < x; i++){
                            if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
                                console.log('empty row - split tail entry: ' + (i == x));
                            }
                            else {
                                vistaCase = new RequestedCase();

                                rowSplit = resultList[i].split('^');
                                if (resultList != undefined){
                                    surgeonSplit = rowSplit[4].split(';');
                                }

                                caseStartDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[6].replace(':',''));
                                caseEndDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[7].replace(':',''));

                                vistaCase.setData({
                                    ien: rowSplit[1],
                                    principalProcedure: rowSplit[2],
                                    dateOfOperation: caseStartDateTime,
                                    caseDuration: (caseEndDateTime - caseStartDateTime)/1000/60,
                                    primarySurgeon: [{
                                        id: surgeonSplit[0],
                                        name: surgeonSplit[1]
                                    }],
                                    orRoom: rowSplit[0],
                                    shouldntBeHere: 'hello'
                                });
                                caseList[i] = vistaCase.sanitize();
                            }
                        }
                    }
                    callback(error, caseList);
                }
            }
        );
    });
};

/*****************************************
 *        Patient Specific Cases         *
 *****************************************/
/**
 * Retrieves list of surgeries for a single patient
 * @param loginOptions
 * @param patientId
 * @param callback
 */
exports.findCasesForPatientWDocs = function(loginOptions, patientId, callback){
    auth.buildConfiguration(loginOptions, function(configuration){
        vista.callRpc(
            vistaconfig.logger,
            configuration,
            'ORWSR LIST',
            patientId,
            function(error, result){
                if(result instanceof Error || result === undefined){
                    callback(result, null);
                }else{
                    //OperationIEN^Description^date^surgeon^case#
                    /* Example print out for patient id = 8
                     57^Stomatch pain^3170804^93;ONE,SURGEON^^0^^^^^^^^1
                     49^something^3170526^93;ONE,SURGEON^^0^^^^^^^^1
                     38^slick fix^3170518^93;ONE,SURGEON^^0^^^^^^^^1
                     32^crown^3170511^93;ONE,SURGEON^^0^^^^^^^^1
                     27^colonoscopy^3170504^93;ONE,SURGEON^^0^^^^^^^^1
                     61^Appendix^3170115^22;DOCTOR,NINE^^0^^^^^^^^1
                     20^injury^3170104^24;DOCTOR,ELEVEN^^0^^^^^^^^1
                     63^bad^3161117^93;ONE,SURGEON^^0^^^^^^^^1
                     5^back surgery^3161114^93;ONE,SURGEON^^0^^^^^^^^1
                     */
                    let resultList = result.split("\r\n");
                    let surgeryList = [];
                    var rowSplit, surgeonSplit, vistaCase;
                    if (resultList instanceof Array){

                        console.log('instance of Array');
                        for (var i = 0, x = resultList.length - 1; i < x; i++){
                            console.log('entry: ' + i + '  -  ' + resultList[i]);
                            if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
                                console.log('empty row - split tail entry: ' + (i == x));
                            }
                            else {
                                vistaCase = new Case();
                                rowSplit = resultList[i].split('^');
                                if (resultList != undefined){
                                    surgeonSplit = rowSplit[3].split(';');
                                }
                                vistaCase.setData({
                                    ien: rowSplit[0],
                                    principalProcedure: rowSplit[1],
                                    dateOfOperation: vista.convertVistaDateToISODate(rowSplit[2]),
                                    primarySurgeons: [{
                                        id: surgeonSplit[0],
                                        name: surgeonSplit[1]
                                    }]
                                });
                                surgeryList[i] = vistaCase.sanitize();
                            }
                        }
                    }
                    else {
                        console.log('not instanceof array: ' + result_list.instance);
                    }
                    callback(error, surgeryList);
                }
            }
        );
    });
}

/**
 * Retrieves placholder cases for specific patient
 * @param loginOptions
 * @param patientId
 * @param callback
 */
exports.getPatientPlaceholderCases = function(loginOptions, patientId, callback) {
    //TODO - implement method
    this.buildMockList(function(list){

        callback(null, list);
    });
    /*auth.buildConfiguration(loginOptions, function(configuration){
     console.log(routine);
     vista.callRpc(
     vistaconfig.logger,
     configuration,
     //TODO - specify routine call and parameters
     '',
     '',
     function(error, result){
     if(result instanceof Error || result === undefined){
     console.log('ERROR');
     callback(result, null);
     }else{
     //OR2^20^injury^3170104^24;DOCTOR,ELEVEN^^20:30^22:00
     //OR2^32^crown^3170511^93;ONE,SURGEON^^20:00^21:00

     let resultList = result.split("\r\n");
     let caseList = [];
     if (resultList instanceof Array){
     var rowSplit, surgeonSplit, vistaCase, caseStartDateTime, caseEndDateTime;
     for (var i = 0, x = resultList.length - 1; i < x; i++){
     if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
     console.log('empty row - split tail entry: ' + (i == x));
     }
     else {
     rowSplit = resultList[i].split('^');
     if (resultList != undefined){
     surgeonSplit = rowSplit[4].split(';');
     }

     caseStartDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[6].replace(':',''));
     caseEndDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[7].replace(':',''));

     vistaCase = {
     ien: rowSplit[1],
     description: rowSplit[2],
     dateOfOperation: caseStartDateTime,
     caseDuration: (caseEndDateTime - caseStartDateTime)/1000/60,
     surgeon: {
     id: surgeonSplit[0],
     name: surgeonSplit[1]
     },
     orRoom: rowSplit[0]
     };
     caseList[i] = vistaCase;
     }
     }
     }
     callback(error, caseList);
     }
     }
     );
     });*/
};

/**
 * Retrieves OR cases for specific patient
 * @param loginOptions
 * @param patientId
 * @param callback
 */
exports.getPatientORCases = function(loginOptions, patientId, callback) {
    //TODO - implement method
    this.buildMockList(function(list){

        callback(null, list);
    });
    /*auth.buildConfiguration(loginOptions, function(configuration){
     console.log(routine);
     vista.callRpc(
     vistaconfig.logger,
     configuration,
     //TODO - specify routine call and parameters
     '',
     '',
     function(error, result){
     if(result instanceof Error || result === undefined){
     console.log('ERROR');
     callback(result, null);
     }else{
     //OR2^20^injury^3170104^24;DOCTOR,ELEVEN^^20:30^22:00
     //OR2^32^crown^3170511^93;ONE,SURGEON^^20:00^21:00

     let resultList = result.split("\r\n");
     let caseList = [];
     if (resultList instanceof Array){
     var rowSplit, surgeonSplit, vistaCase, caseStartDateTime, caseEndDateTime;
     for (var i = 0, x = resultList.length - 1; i < x; i++){
     if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
     console.log('empty row - split tail entry: ' + (i == x));
     }
     else {
     rowSplit = resultList[i].split('^');
     if (resultList != undefined){
     surgeonSplit = rowSplit[4].split(';');
     }

     caseStartDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[6].replace(':',''));
     caseEndDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[7].replace(':',''));

     vistaCase = {
     ien: rowSplit[1],
     description: rowSplit[2],
     dateOfOperation: caseStartDateTime,
     caseDuration: (caseEndDateTime - caseStartDateTime)/1000/60,
     surgeon: {
     id: surgeonSplit[0],
     name: surgeonSplit[1]
     },
     orRoom: rowSplit[0]
     };
     caseList[i] = vistaCase;
     }
     }
     }
     callback(error, caseList);
     }
     }
     );
     });*/
};

/**
 * Retrieves list of OR cases for a specified patient and date range
 * @param loginOptions
 * @param patientId
 * @param startDate
 * @param endDate
 * @param callback
 */
exports.getPatientORCasesByDateRange = function(loginOptions, patientId, startDate, endDate, callback){
    auth.buildConfiguration(loginOptions, function(configuration){
        console.log("***DATES***");
        console.log(startDate);
        console.log(vista.convertToVistaDateNoTime(startDate));
        console.log(endDate);
        console.log(vista.convertToVistaDateNoTime(endDate));

        vista.callRpc(
           vistaconfig.logger,
           configuration,
           'SR GET ORNONOR CASES',
           patientId,
           vista.convertToVistaDateNoTime(startDate),
           vista.convertToVistaDateNoTime(endDate),
           0,
           function(error, result){
               if (error){
                   console.log("Error: " + error);
                   callback(error, null);
               }
               else{
                   console.log("found or cases for patient by date");
                   //console.log(result);
                   var result_split = result.split("\r")
                   console.log(result_split);
                   callback(null, result_split);
                   /*5^3^^1^C^N^^^3170522^A^3^2^^^^^^^^1^^^^^^2\r
                   5^2^^5^C^N^^^3170212^A^3^2^^^^^^^^1\r
                   5^1^^1^C^N^^^3170106^EM^1^2^^^^^^^^1\r
                   5^2^^1^^N^^^3170106^^^2^^^^^^^^1\r
                   5^1^^3^^^^^3170112^^^^^^^^^^^1\r*/
                   //TODO - parse through data once complete
               }

           }
       ) ;
    });
}

/**
 * Retrieves OR cases for specific patient
 * @param loginOptions
 * @param patientId
 * @param callback
 */
exports.getPatientNonORCases = function(loginOptions, patientId, callback) {
    //TODO - implement method
    this.buildNORMockList(function(list){
        callback(null, list);
    });
    /*auth.buildConfiguration(loginOptions, function(configuration){
     console.log(routine);
     vista.callRpc(
     vistaconfig.logger,
     configuration,
     //TODO - specify routine call and parameters
     '',
     '',
     function(error, result){
     if(result instanceof Error || result === undefined){
     console.log('ERROR');
     callback(result, null);
     }else{
     //OR2^20^injury^3170104^24;DOCTOR,ELEVEN^^20:30^22:00
     //OR2^32^crown^3170511^93;ONE,SURGEON^^20:00^21:00

     let resultList = result.split("\r\n");
     let caseList = [];
     if (resultList instanceof Array){
     var rowSplit, surgeonSplit, vistaCase, caseStartDateTime, caseEndDateTime;
     for (var i = 0, x = resultList.length - 1; i < x; i++){
     if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
     console.log('empty row - split tail entry: ' + (i == x));
     }
     else {
     rowSplit = resultList[i].split('^');
     if (resultList != undefined){
     surgeonSplit = rowSplit[4].split(';');
     }

     caseStartDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[6].replace(':',''));
     caseEndDateTime = vista.convertFromVistaDate(rowSplit[3] + '.' + rowSplit[7].replace(':',''));

     vistaCase = {
     ien: rowSplit[1],
     description: rowSplit[2],
     dateOfOperation: caseStartDateTime,
     caseDuration: (caseEndDateTime - caseStartDateTime)/1000/60,
     surgeon: {
     id: surgeonSplit[0],
     name: surgeonSplit[1]
     },
     orRoom: rowSplit[0]
     };
     caseList[i] = vistaCase;
     }
     }
     }
     callback(error, caseList);
     }
     }
     );
     });*/
};


/**
 * Retrieves list of OR cases for a specified patient and date range
 * @param loginOptions
 * @param patientId
 * @param startDate
 * @param endDate
 * @param callback
 */
exports.getPatientNonORCasesByDateRange = function(loginOptions, patientId, startDate, endDate, callback) {
    auth.buildConfiguration(loginOptions, function (configuration) {
        console.log("***DATES***");
        console.log(startDate);
        console.log(vista.convertToVistaDateNoTime(startDate));
        console.log(endDate);
        console.log(vista.convertToVistaDateNoTime(endDate));

        vista.callRpc(
            vistaconfig.logger,
            configuration,
            'SR GET ORNONOR CASES',
            patientId,
            vista.convertToVistaDateNoTime(startDate),
            vista.convertToVistaDateNoTime(endDate),
            1,
            function (error, result) {
                if (error) {
                    console.log("Error: " + error);
                    callback(error, null);
                }
                else {
                    console.log("found nor cases for patient by date");
                    //console.log(result);
                    var result_split = result.split("\r")
                    console.log(result_split);
                    callback(null, result_split);
                    //TODO-parse through data
                }

            }
        );
    });
}

/************************************************************************************
 *        Methods that are not documented in API - used for testing early on        *
 ************************************************************************************/
//DVBAB - DOES NOT RETURN A CONSISTENT LIST
exports.findCasesForPatient = function(loginOptions, patientId, callback){
    auth.buildConfiguration(loginOptions, function(configuration) {
        vista.callRpc(
            vistaconfig.logger,
            configuration,
            'DVBAB SURGERY CASE',
            patientId,
            function (error, result) {
                if (result instanceof Error || result === undefined) {
                    callback(result, null);
                } else {

                    let resultList = result.split("\r");
                    if (resultList instanceof Array) {
                        var surgeryList = [];
                        var surgery, rowSplit, surgeonSplit;

                        for (var i = 0, x = resultList.length - 1; i < x; i++) {
                            if (resultList[i] === undefined || resultList[i] === null || resultList[i] === ''){
                             console.log('empty row - split tail entry: ' + (i == x));
                             }
                             else {
                             rowSplit = resultList[i].split('^');
                             if (resultList != undefined){
                             surgeonSplit = rowSplit[3].split(';');
                             }
                             surgery = {
                             ien: rowSplit[0],
                             description: rowSplit[1],
                             date: vista.convertVistaDateToISODate(rowSplit[2]),
                             surgeon: {
                             id: surgeonSplit[0],
                             name: surgeonSplit[1]
                             },
                             caseNum: rowSplit[4]
                             };
                             surgeryList[i] = surgery;
                             }
                        }
                        callback(error, surgeryList);
                    }
                    else {
                        console.log('not instance of array');
                        var resultSplit = result.split('^');
                        if (resultSplit instanceof Array) {
                            var surgery;
                            for (var i = 0, x = resultSplit.length; i < x; i++) {
                                console.log('entry-' + i + ': ' + resultSplit[i]);
                                surgery = {
                                    description: result_split[2]
                                };
                            }
                        }
                        callback(error, surgery);
                    }
                }
            }
        );
    });
}

//MAGGSUR GET
exports.findPatientSurgeryProcedures = function(loginOptions, patientId, callback){
    auth.buildConfiguration(loginOptions, function(configuration) {
        vista.callRpc(
            vistaconfig.logger,
            configuration,
            'MAGGSUR GET',
            patientId,
            function (error, result) {
                if (result instanceof Error || result === undefined) {
                    callback(result, null);
                } else {
                    /*Example print out for patient id = 8
                     9^
                     #^Date^Case description^Case #^Images
                     1^11/14/2016^back surgery (REQUESTED)^5^0^|5^3161114^
                     2^11/17/2016^bad (SCHEDULED)^63^0^|63^3161117^
                     3^01/04/2017^injury, none (SCHEDULED)^20^0^|20^3170104^
                     4^01/15/2017^Appendix (REQUESTED)^61^0^|61^3170115^
                     5^05/04/2017^colonoscopy (REQUESTED)^27^0^|27^3170504^
                     6^05/11/2017^crown (SCHEDULED)^32^0^|32^3170511^
                     7^05/18/2017^slick fix (REQUESTED)^38^0^|38^3170518^
                     8^05/26/2017^something (REQUESTED)^49^0^|49^3170526^
                     9^08/04/2017^Stomatch pain (REQUESTED)^57^0^|57^3170804^
                     */
                    let resultList = result.split("\r\n");
                    let surgeryList = [];
                    if (resultList instanceof Array) {
                        var surgery, rowSplit;
                        // Start with i = 2 to skip the first two rows
                        for (var i = 2, x = resultList.length; i < x; i++) {
                            if (resultList[i] != undefined && resultList[i] != null || resultList[i] != '') {
                                rowSplit = resultList[i].split('^');
                                surgery = {
                                    date: rowSplit[1],
                                    description: rowSplit[2],
                                    caseNum: rowSplit[3],
                                    //images: rowSplit[4]
                                };
                                surgeryList.push(surgery);
                            }
                        }
                    }

                    callback(error, surgeryList);
                }
            }
        );
    });
};

exports.buildNORMockList = function(callback) {
    let list = [];
    let vistaCase = new NonOrCase();
    vistaCase.setData({
        "ien": "15",
        "principalProcedure": "Operation Description, Short Name",
        "procedureDate": "2016-11-14T05:00:00.000Z",
        "provider": [{
            "id": "93",
            "name": "ONE,SURGEON"
        }]
    });
    list.push(vistaCase.sanitize());
    vistaCase = new NonOrCase();
    vistaCase.setData({
        "ien": "12",
        "principalProcedure": "Operation Name",
        "procedureDate": "2016-11-11T14:05:00.000Z",
        "provider": [{
            "id": "93",
            "name": "ONE,SURGEON"
        }]
    });
    list.push(vistaCase.sanitize());
    vistaCase = new NonOrCase();
    vistaCase.setData({
        "ien": "48",
        "principalProcedure": "OPERATION REPORT",
        "procedureDate": "2016-11-11T14:05:00.000Z",
        "provider": [{
            "id": "93",
            "name": "ONE,SURGEON"
        }]
    });
    list.push(vistaCase.sanitize());
    vistaCase = new NonOrCase();
    vistaCase.setData({
        "ien": "47",
        "principalProcedure": "NURSE INTRAOPERATIVE REPORT",
        "procedureDate": "2016-11-11T14:05:00.000Z",
        "provider": [{
            "id": "93",
            "name": "ONE,SURGEON"
        }]
    });
    list.push(vistaCase.sanitize());

    callback(list);
};

exports.buildMockList = function(callback){
    let list = [];
    let vistaCase = new RequestedCase();
    vistaCase.setData({
        "ien": "15",
        "principalProcedure": "Operation Description, Short Name",
        "dateOfOperation": "2017-01-14T05:00:00.000Z",
        "primarySurgeons":[{
            "id": "93",
            "name": "ONE,SURGEON"
        }]
    });
    list.push(vistaCase.sanitize());
    vistaCase = new RequestedCase();
    vistaCase.setData({
        "ien": "12",
        "principalProcedure": "Operation Name",
        "dateOfOperation": "2017-01-11T14:05:00.000Z",
        "primarySurgeons":[{
            "id": "93",
            "name": "ONE,SURGEON"
        }]
    });
    list.push(vistaCase.sanitize());
    vistaCase = new RequestedCase();
    vistaCase.setData( {
        "ien": "48",
        "principalProcedure": "OPERATION REPORT",
        "dateOfOperation": "2017-01-11T14:05:00.000Z",
        "primarySurgeons":[{
            "id": "93",
            "name": "ONE,SURGEON"
        }]
    });
    list.push(vistaCase.sanitize());
    vistaCase = new RequestedCase();
    vistaCase.setData( {
        "ien": "47",
        "principalProcedure": "NURSE INTRAOPERATIVE REPORT",
        "dateOfOperation": "2017-01-11T14:05:00.000Z",
        "primarySurgeons":[{
            "id": "93",
            "name": "ONE,SURGEON"
        }]
    });
    list.push(vistaCase.sanitize());

    callback(list);

};

exports.REQUESTED = 'requested';
exports.SCHEDULED = 'scheduled';
exports.PLACEHOLDER = 'placeholder';
