/**
 * Site Service
 * @author atignola
 */
// required imports
const mongoose = require('mongoose');
// note the import of the mongoose model
const TemplateCase = mongoose.model('TemplateCase');


/**
 * Create new template case
 * @param templateCaseData
 * @param callback
 */
exports.create = function(templateCaseData, callback){
    const config = new TemplateCase(templateCaseData);
    // save function, will create a new record in the templateCae collection in mongo
    config.save(function(err){
        if(err) {console.log(err); callback( err);}
        callback(config);
    });
}

/**
 * Edit existing template case
 * @param templateCaseData
 * @param callback
 */
exports.edit = function(id, templateCaseData, callback){
    //console.log("Entering edit ...");
    TemplateCase.findOne({_id:id},function(err, existingCase){
        //console.log("TemplateCase.find");
        console.log(existingCase);
        if(err ){
            callback(err, null);
        }
        else if (existingCase === null || existingCase === undefined){
            callback("Case does not exist.", null);
        }
        else{
            // Update case
            for (var property in templateCaseData){
                if (property !== "_id"){
                    // TODO Implement audit for changes
                    existingCase[property] = templateCaseData[property];
                }
            }
            existingCase.save(function(err){
                if(err){
                    console.log(err);
                    callback(err, null);
                }
                else{
                    console.log("SUCCESS");
                    callback(null, "SUCCESS");
                }
            })
        }

    });

    // config.save(function(err){
    //     if(err) {console.log(err); callback( err);}
    //     callback(config);
    // });
}

/**
 Function find all template cases
 @param callback
 */
exports.findAll = function(callback){
    //console.log("TemplateCase.findAll");
    TemplateCase.find({}, null, {sort: {dateOfOperation: 1}}, function(err, docs){
        if(!err){
            callback(docs);
        } else {
            callback(err);
        }
    });
}

/**
 Find template case by id
 @param stationID
 @param callback
 */
exports.find = function(id, callback){
    TemplateCase.findOne({_id:id},function(err, docs){
        //console.log("TemplateCase.find");
        if(!err){
            callback(docs);
        } else {
            callback(err);
        }
    });
}

/**
 Find template case by principalProcedure
 @param principalProcedure
 @param callback
 */
exports.findByProcedureName = function(principalProcedure, callback){
    TemplateCase.findOne({principalProcedure:principalProcedure},function(err, docs){
        //console.log("TemplateCase.find");
        if(!err){
            callback(docs);
        } else {
            callback(err);
        }
    });
}

/**
 Delete template case by ID
 @param id
 @param callback
 */
exports.remove = function(id, callback){
    TemplateCase.remove({_id:id},function(err, removed){
        //console.log(removed);
        if(!err){callback (removed);}
        else {console.log(err);}
    });
}