/**
 * Role Service
 * @author atignola
 */
"use strict";

// required imports
const mongoose = require('mongoose');
const Role = mongoose.model('Role');


/**
 * Create new role
 * @param role_data
 * @param callback
 */
exports.create = function(role_data, callback){
    const config = new Role(role_data);
    // save function, will create a new record in the card collection in mongo
    config.save(function(err){
        if(err) {console.log(err); callback( err);}
        callback(config);
    });
}

/**
 * Edit existing role
 * @param roleData
 * @param callback
 */
exports.edit = function(id, roleData, callback) {
    //console.log("Entering edit ...");
    Role.findOne({_id: id}, function (err, existingRole) {
        if (err) {
            callback(err, null);
        }
        else if (existingRole === null || existingRole === undefined) {
            callback("Case does not exist.", null);
        }
        else {
            // Update role
            for (var property in roleData) {
                if (property !== "_id") {
                    // TODO Implement audit for changes
                    existingRole[property] = roleData[property];
                }
            }
            existingRole.save(function (err) {
                if (err) {
                    console.log(err);
                    callback(err, null);
                }
                else {
                    console.log("SUCCESS");
                    callback(null, "SUCCESS");
                }
            })
        }

    });
}

/**
 * Get the list of roles for access management
 * @param callback
 */
exports.getAllRoles = function(callback){
    //console.log("Role.findAll");
    Role.find({}, null, {sort: {role: 1}}, function(err, docs){
        if(!err){
            callback(docs);
        } else {
            callback(err);
        }
    });
}

/**
 * Get role by id
 * @param callback
 */
exports.getRoleById = function(id, callback){
    Role.findOne({_id:id}, function(err, docs){
        if(!err){
            callback(docs);
        } else {
            callback(err);
        }
    });
}

/**
 * Get the list of role names in the dbt
 * @param callback
 */
exports.getRoleNamesList = function(callback){
    //console.log("Role.findAll");
    Role.find().distinct('role', function(err, docs){
        if(!err){
            callback(docs);
        } else {
            callback(err);
        }
    });
}

/**
 * Get the list of all existing keys in mongo db
 * @param callback
 */
exports.getKeysList = function(callback){
    Role.find().distinct('keys', function(err, docs){
        if(!err){
            callback(docs);
        } else {
            callback(err);
        }
    });
}

/**
 * Get list of roles that have all keys
 * @param userKeys
 * @param callback
 */
exports.getRolesForKeys = function(userKeys, callback)
{
    let i, j, n, o, role, rKeys;
    let addRole = true;
    let userRoles = [];

    if (userKeys != undefined) {
        Role.find({}, 'role keys', {sort: {role: 1}}, function (err, roles) {
            if (!err) {
                // Got all roles - check keys
                for (i = 0, n = roles.length; i < n; i++) {
                    // Check if user has all of the same keys for role
                    role = roles[i];
                    rKeys = role.keys;
                    addRole = true;
                    for(j = 0, o = rKeys.length; j < o; j++){
                        if (userKeys.includes(rKeys[j]) === false){
                            addRole = false;
                            break;
                        }
                    }

                    if (addRole === true){
                        userRoles.push(role.role);
                    }
                }
                callback(userRoles);
            } else {
                console.log('error');
                callback(err);
            }
        });
    }else {console.log('userkeys undefined');}

}

/**
 * Get the list of roles associated with key
 * @param pKey - the key to map
 * @param callback
 */
exports.getRolesByKey = function(pKey, callback){
    console.log('getRolesByKey:' + pKey);
    Role.find({keys: pKey}, null, {sort: {role: 1}}, function(err, docs){
        if(!err){
            console.log('found something');
            console.log(docs);
            callback(docs);
        } else {
            console.log('error');
            callback(err);
        }
    });
}

/**
 Delete template case by ID
 @param id
 @param callback
 */
exports.remove = function(id, callback){
    Role.remove({_id:id},function(err, removed){
        if(!err){callback(null, removed);}
        else {console.log(err, null);}
    });
}

