/** config.js **/

/** 
controller is where the methods required to retrieve information 
about schema's are defined

The create, read, update, delete functions should be here
**/

const mongoose = require('mongoose');
// note the import of the mongoose model
const Config = mongoose.model('Config');


// create new
exports.create = function(config_data, callback){	
	const config = new Config(config_data);
	// save function, will create a new record in the card collection in mongo
	config.save(function(err){
		if(err) {console.log(err); callback( err);}
		callback(config); 
	});
}

/**
Function Find all
*/
exports.findAll = function(callback){
	// empty find {} will return all
	Config.find({}, function(err, docs){
		if(!err){
			callback(docs);
		} else {
			callback(err);
		}
	});
}

/**
Delete Configuration
*/
exports.delete = function(callback){
	// findByIdAndRemove is just one of the many find functions in mongoose
	Config.find().remove(function(err, removed){
		callback (removed);
	});
}

