'use strict';
const vistaconfig = require("../../lib/rpcvista/vistaconfig");
const vista = require("../../lib/rpcvista/VistaJS");
const site = require("./cnf/site");

/**
* Verify that access code and verify code are valid
**/
exports.verify = function(loginOptions, callback){
  this.buildConfiguration(loginOptions, function(result){
    vista.authenticate(vistaconfig.logger, result, callback);
  });
}

exports.retrieveKeys = function(loginOptions, ien, callback){
  this.buildConfiguration(loginOptions, function(configuration){
    vista.callRpc(
        vistaconfig.logger,
        configuration,
        'SR GET USRKEYS',
        ien,
        function(error, result){
          if (result instanceof Error || result === undefined) {
            callback(result, null);
          } else {
            console.log('roles');
            console.log(result);
            callback(error, result);
          }
        }
    )

  });
}

exports.buildConfiguration = function(loginOptions, callback) {
  site.getConnectionInfo(loginOptions[vistaconfig.STATION_CONFIG_KEY], function(result){
    let configuration = vistaconfig.configuration;

    // TODO - update this logic
    configuration[vistaconfig.ACCESS_CONFIG_KEY] = loginOptions[vistaconfig.ACCESS_CONFIG_KEY] || loginOptions[vistaconfig.T_ACCESS_CONFIG_KEY];
    configuration[vistaconfig.VERIFY_CONFIG_KEY] = loginOptions[vistaconfig.VERIFY_CONFIG_KEY] || loginOptions[vistaconfig.T_VERIFY_CONFIG_KEY];

      if (result != undefined && result.ipAddress != undefined && result.port != undefined) {
        configuration[vistaconfig.HOST_CONFIG_KEY] = result.ipAddress;
        configuration[vistaconfig.PORT_CONFIG_KEY] = result.port;
      }
    callback(configuration);
  });
}