'use strict';
require('dotenv').config();
const express = require('express'),
    roomRouter = express.Router();

const roomService = require("../../services/rpc/room");



roomRouter.route("/or/case/:id")
    .get(function(req, res){
        roomService.getRoomDetailsByCaseId(req.decoded, req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });


roomRouter.route("/or/:id")
    .get(function(req, res){
        roomService.getRoomDetailsById(req.decoded, req.params.id, function(error, result){
            if(error){
                console.log(error);
                res.json(error);
            }
            else{
                res.json(result);
            }
        });
    });

module.exports = roomRouter;