'use strict';
require('dotenv').config();
const express = require('express'),
    requestedRouter = express.Router();
const caseService = require("../../services/rpc/case");
const util = require("../utils");

/***********************
 *   Requested Routes  *
 ***********************/
requestedRouter.route("/:startdate/:enddate")
    .get(function(req, res){
        var start = new Date(req.params.startdate);
        var end = new Date(req.params.enddate);

        // Modify date to reflect correct date passed
        start.setDate(start.getDate() + 1);
        end.setDate(end.getDate() + 1);

        caseService.findCasesForDateRange(req.decoded, start, end, caseService.REQUESTED, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

requestedRouter.route("/date/:year/:month")
    .get(function(req, res){
        util.lastDayOfMonth(req.params.month, req.params.year, function(endDay){
            caseService.findCasesForDateRange(req.decoded, new Date(req.params.year, req.params.month - 1, 1), new Date(req.params.year, req.params.month - 1, endDay), caseService.REQUESTED, function(err, result){
                if(err){ res.json(err);}
                else{res.json(result);}
            });
        });

    });

requestedRouter.route("/date/:year/:month/:day")
    .get(function(req, res){
        let day = parseInt(req.params.day, 10);
        caseService.findCasesForDateRange(req.decoded, new Date(req.params.year, req.params.month - 1, day), new Date(req.params.year, req.params.month - 1, day + 1), caseService.REQUESTED, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

module.exports = requestedRouter;