'use strict';
require('dotenv').config();
const express = require('express'),
    placeholderRouter = express.Router();
const placeholderCaseService = require("../../services/rpc/placeholderCase");
const util = require("../utils");

/************************
 *   Placeholder Routes  *
 ************************/
placeholderRouter.route("/")
    .post(function(req, res){
        placeholderCaseService.createPlaceholderCase(req.decoded, req.body, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });


placeholderRouter.route("/")
    .get(function(req, res){

        placeholderCaseService.findPlaceholderCases(req.decoded, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/:startdate/:enddate")
    .get(function(req, res){
        var start = new Date(req.params.startdate);
        var end = new Date(req.params.enddate);

        // Modify date to reflect correct date passed
        start.setDate(start.getDate() + 1);
        end.setDate(end.getDate() + 1);

        placeholderCaseService.findPlaceholderCasesForDateRange(req.decoded, start, end, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/date/:year/:month")
    .get(function(req, res){
        util.lastDayOfMonth(req.params.month, req.params.year, function(endDay){
            placeholderCaseService.findPlaceholderCasesForDateRange(req.decoded, new Date(req.params.year, req.params.month - 1, 1), new Date(req.params.year, req.params.month - 1, endDay), function(err, result){
                if(err){ res.json(err);}
                else{res.json(result);}
            });
        });

    });

placeholderRouter.route("/date/:year/:month/:day")
    .get(function(req, res){
        let day = parseInt(req.params.day, 10);
        placeholderCaseService.findPlaceholderCasesForDateRange(req.decoded, new Date(req.params.year, req.params.month - 1, day), new Date(req.params.year, req.params.month - 1, day + 1 ), function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/export/")
    .get(function(req, res){
        placeholderCaseService.findPlaceholderCases(req.decoded, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/export/:startdate/:enddate")
    .get(function(req, res){
        var start = new Date(req.params.startdate);
        var end = new Date(req.params.enddate);

        // Modify date to reflect correct date passed
        start.setDate(start.getDate() + 1);
        end.setDate(end.getDate() + 1);

        placeholderCaseService.findPlaceholderCasesForDateRange(req.decoded, start, end, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/export/date/:year/:month")
    .get(function(req, res){
        util.lastDayOfMonth(req.params.month, req.params.year, function(endDay){
            placeholderCaseService.findPlaceholderCasesForDateRange(req.decoded, new Date(req.params.year, req.params.month - 1, 1), new Date(req.params.year, req.params.month - 1, endDay), function(err, result){
                if(err){ res.json(err);}
                else{res.json(result);}
            });
        });

    });

placeholderRouter.route("/export/date/:year/:month/:day")
    .get(function(req, res){
        let day = parseInt(req.params.day, 10);
        placeholderCaseService.findPlaceholderCasesForDateRange(req.decoded, new Date(req.params.year, req.params.month - 1, day), new Date(req.params.year, req.params.month - 1, day + 1 ), function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

placeholderRouter.route("/import")
    .post(function(req, res){
        placeholderCaseService.createMultiplePlaceholderCases(req.decoded, req.body, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

/**
 * Updates an existing placeholder case with new data
 */
placeholderRouter.route("/:id")
    .post(function(req, res){
        placeholderCaseService.editPlaceholderCase(req.decoded, req.body, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

module.exports = placeholderRouter;