'use strict';
require('dotenv').config();
let express = require('express'),
	patientRouter = express.Router();

const patientService = require("../../services/rpc/patient");
const caseService = require("../../services/rpc/case");

/*********************
 *   Patient Routes  *
 *********************/

patientRouter.route("/all")
	.get(function(req, res){
		patientService.getAllPatients(req.decoded, function(err, result){
			if(err) {res.json(err);}
			else {res.json(result);}
		});
	});

/**
GET patient by SSN
**/
patientRouter.route("/ssn/:ssn")
	.get(function(req, res){
		patientService.findPatientBySSN(req.decoded, req.params.ssn, function(err, result){
			if(err)res.json(err);
			else res.json(result);
		});
	});

/**
GET patient by Last Five
**/
patientRouter.route("/five/:lastFive")
	.get(function(req, res){
		patientService.findPatientByLastFive(req.decoded, req.params.lastFive, function(err, result){
			if(err)res.json(err);
			else res.json(result);
		});
	});


/**
GET patient data
**/
patientRouter.route("/:id")
	.get(function(req, res){
		patientService.selectPatient(req.decoded, req.params.id, function(err, result){
			if(err)res.json(err);
			else res.json(result);
		});
	});

/**
GET Patient Record
*/
patientRouter.route("/record/:id")
	.get(function(req, res){
		patientService.getVirtualPatientRecord(req.decoded, req.params.id, null, function(err, result){
			if(err)res.json(err);
			else res.json(result);
		});
	});

/**************************
 *   Patient Case Routes  *
 **************************/
/**
 * GET All Patient Cases
 */
patientRouter.route("/:id/cases")
	.get(function(req, res){
        caseService.findCasesForPatientWDocs(req.decoded, req.params.id, function(err, result){
			if(err){res.json(err);}
			else {res.json(result);}
        });
	});

/**
 * GET Patient Requested Cases
 */
patientRouter.route("/:id/cases/placeholder")
    .get(function(req, res){
        caseService.getPatientPlaceholderCases(req.decoded, req.params.id, function(err, result){
            if(err){res.json(err);}
            else {res.json(result);}
        });
    });

/**
 * GET Patient OR Cases
 */
patientRouter.route("/:id/cases/or")
    .get(function(req, res){
        caseService.getPatientORCases(req.decoded, req.params.id, function(err, result){
            if(err){res.json(err);}
            else {res.json(result);}
        });
    });

/**
 * GET Patient Non-OR Cases
 */
patientRouter.route("/:id/cases/nor")
    .get(function(req, res){
        caseService.getPatientNonORCases(req.decoded, req.params.id, function(err, result){
            if(err){res.json(err);}
            else {res.json(result);}
        });
    });

/**
 * GET Specific Patient Case
 */
patientRouter.route("/:id/cases/:caseId")
    .get(function(req, res){
        caseService.findCaseById(req.decoded, req.params.caseId, function(err, result){
            if(err){res.json(err);}
            else {res.json(result);}
        });
    });

module.exports = patientRouter;