'use strict';
require('dotenv').config();
const express = require('express'),
    caseRouter = express.Router();

const caseService = require("../../services/rpc/case");
const roomService = require("../../services/rpc/room");


caseRouter.use("/placeholder", require("./placeholderCase"));
caseRouter.use("/requested", require("./requestedCase"));
caseRouter.use("/scheduled", require("./scheduledCase"));
caseRouter.use("/template", require("../cnf/templateCase"));


/**************************
 *   General Case Routes  *
 **************************/

/**
 GET All Cases
 **/
caseRouter.route("/")
    .get(function(req, res){
        caseService.findAllCases(req.decoded, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET Cases by Case ID
 **/
caseRouter.route("/:caseId")
    .get(function(req, res){
        caseService.findCaseById(req.decoded, req.params.caseId, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

/**
 * POST Cancel Case by Case ID
 */
caseRouter.route("/cancel/:caseId")
    .post (function(req, res){
    caseService.cancelCase(req.decoded, req.params.caseId, req.body, function(err, result){
        if(err){ res.json(err);}
        else{res.json(result);}
    });
});

/**
 * POST Reschedule Case by Case ID
 */
caseRouter.route("/reschedule/:caseId")
    .post (function(req, res){
        caseService.rescheduleCase(req.decoded, req.params.caseId, req.body, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });

/******************
 *   Room Routes  *
 ******************/
caseRouter.route("/room/:caseId")
    .get(function(req, res){
        roomService.getRoomDetailsByCaseId(req.decoded, req.params.caseId, function(err, result){
            if(err){ res.json(err);}
            else{res.json(result);}
        });
    });



/*******************
 *   Other Routes  *
 *******************/

caseRouter.route("/dvbab/:patientId")
    .get(function(req, res){
        console.log('surgery/dvbab/patientId');
        caseService.findCasesForPatient(req.decoded, req.params.patientId, function(err, result){
            if(err){ res.json(err);}
            else{ res.json(result);}
        });
    });

caseRouter.route("/procedure/:patientId")
    .get(function(req, res){
        console.log('surgery/patientId/#');
       caseService.findPatientSurgeryProcedures(req.decoded, req.params.patientId,function(err, result){
         if(err){ res.json(err);}
         else{res.json(result);}
       });
    });





module.exports = caseRouter;