/**
 * TemplateCase Route
 * @author atignola
 */

'use strict';
require('dotenv').config();
let express = require('express'),
    templateCaseRouter = express.Router();

const templateCaseService = require("../../services/cnf/templateCase");

/**
 * POST new template case
 */
templateCaseRouter.route("/")
    .post(function(req, res){
        templateCaseService.create(req.body, function(err, result){
            if (err) { res.json(err); }
            else { res.json(result); }
        });
    });

/**
 * POST edit existing template case
 */
templateCaseRouter.route("/:id")
    .post(function(req, res){
        console.log(req.body);
        templateCaseService.edit(req.params.id, req.body, function(err, result){
            if (err) { res.json(err); }
            else { res.json(result); }
        });
    });

/**
 GET all template cases
 **/
templateCaseRouter.route("/")
    .get(function(req, res){
        templateCaseService.findAll(function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET template case by principal procedure
 **/
templateCaseRouter.route("/procedure/:principalProcedure")
    .get(function(req, res){
        templateCaseService.findByProcedureName(req.params.principalProcedure, function(err, result){
            if(err){res.json(err);}
            else {res.json(result);}
        });
    });

/**
 GET template case by id
 **/
templateCaseRouter.route("/:id")
    .get(function(req, res){
        templateCaseService.find(req.params.id, function(err, result){
            if(err){res.json(err);}
            else {res.json(result);}
        });
    });

/**
 * DELETE template case by id
 */
templateCaseRouter.route("/:id")
    .delete(function(req, res){
        templateCaseService.remove(req.params.id, function(err, result){
            if (err) { res.json(err); }
            else { res.json(result); }
        });
    });

module.exports = templateCaseRouter;