/**
 * Site Route
 * @author atignola
 */

'use strict';
require('dotenv').config();
let express = require('express'),
    siteRouter = express.Router();

const siteService = require("../../services/cnf/site");

/**
 * POST new site
 */
siteRouter.route("/")
    .post(function(req, res){
       siteService.create(req.body, function(err, result){
              if (err) { res.json(err); }
               else { res.json(result); }
           });
    });


/**
 GET all facility sites
 **/
siteRouter.route("/")
    .get(function(req, res){
        siteService.findAll(function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });

/**
 GET site by id
 **/
siteRouter.route("/:stationID")
    .get(function(req, res){
        siteService.find(req.params.stationID, function(err, result){
            if(err){res.json(err);}
            else {res.json(result);}
        });
    });

/**
 * DELETE site by stationID
 */
siteRouter.route("/:stationID")
    .delete(function(req, res){
        siteService.remove(req.params.stationID, function(err, result){
            if (err) { res.json(err); }
            else { res.json(result); }
        });
    });

module.exports = siteRouter;