'use strict';
require('dotenv').config();
let express = require('express'),
    configRouter = express.Router();

const configService = require("../../services/cnf/config");

/**
 * GET all configs
 */
configRouter.route("/")
    .get(function(req, res){
        configService.findAll(function(err, result){
            if (err) { res.json(err); }
            else { res.json(result); }
        });
    });


/**
 POST create new config
 **/
configRouter.route("/")
    .post(function(req, res){
        configService.create(req.body, function(err, result){
            if(err){res.json(err);}
            else{res.json(result);}
        });
    });


/**
 * DELETE config
 */
configRouter.route("/")
    .delete(function(req, res){
        configService.delete(function(err, result){
            if (err) { res.json(err); }
            else { res.json(result); }
        });
    });

module.exports = configRouter;