/**
 API_v1.js

 All Api routes will go here
 **/
'use strict';
require('dotenv').config();
let express = require('express');
let v1 = express.Router();
// import the controllers here


/**
 Single way of doing all the HTTP verb(s)
 **/

// set configuration router paths
v1.use("/config", require("./cnf/config"));
v1.use("/facilities", require("./cnf/site"));
v1.use("/roles", require("./cnf/role"));

// set rpc router paths
v1.use("/patient", require("./rpc/patient"));
v1.use("/cases", require("./rpc/case"));

v1.use("/cases/placeholder", require("./rpc/placeholderCase"));


v1.use("/room", require("./rpc/room"));

module.exports = v1;