/**
 * Site model
 * @author atignola
 */

// required imports to define schema
const mongoose = require('mongoose');
const Schema = mongoose.Schema;

const SiteSchema = new Schema({
  stationID : String,
  facilityName : String,
  complexityLevel : String,
  facilitySize: String,
  state : String,
  visn: String,
  ipAddress : String,
  port: String
});

SiteSchema.path('stationID').required(true, 'Station ID cannot be blank');
SiteSchema.path('facilityName').required(true, 'Facility Name cannot be blank');

mongoose.model('Site', SiteSchema, "site");