/** schemas.js **/

schemas = {  
    user: {
        id: null,
        name: null,
        password: null
       },
    patient:{
    	dfn: null,
        name: null,
        gender: null,
        dob: null,
        age: null,
        ssn: null,
        birthCity: null,
        birthState: null,
        provider: null,
        roomBed: null,
        currentRoom: null,
        addrStreet1: null,
        addrStreet2: null,
        addrStreet3: null,
        addrCity: null,
        addrState: null,
        addrZip: null,
        addrCounty: null,
        addrProvince: null,
        addCountry: null,
        addrForeignPostCode: null,
        addrZipExt: null,
        resPhoneNum: null,
        workPhonNum: null,
        email: null,
        kName: null,
        kRelationship: null,
        kAddressPatientAddress: null,
        kStreet1: null,
        kStreet2: null,
        kStreet3: null,
        kCity: null,
        kState: null,
        kZip: null,
        kPhone: null,
        scYesNo: null,
        scAwardDate: null
    },
    case:{
        ien: null,
        patient: null,
        caseCreateDate: null,
        dateOfOperation: null,
        principalProcedure: null,
        otherProcedures: null,
        generalComments: null,
        plannedPostopCare: null,
        plannedPrincOpProcCPT: null,
        operationIndications: null,
        briefClinHistory: null,
        procedureLaterality: null
    }
}

// NON OR CASE
schemas.nonOrCase = schemas.case;
schemas.nonOrCase['hospitalAdmissionStatus'] = null;
schemas.nonOrCase['serviceConnected'] = null;
schemas.nonOrCase['associatedClinic'] = null;
schemas.nonOrCase['resSupCode'] = null;
schemas.nonOrCase['anesCareTimeBlock'] = null;
schemas.nonOrCase['princAnesthetist'] = null;
schemas.nonOrCase['anesthesiologistSupvr'] = null;
schemas.nonOrCase['anesSuperviseCode'] = null;
schemas.nonOrCase['anesthesiaTechnique'] = null;
schemas.nonOrCase['otherPostopDiags'] = null;
schemas.nonOrCase['asaClass'] = null;
schemas.nonOrCase['cancelDate'] = null;
schemas.nonOrCase['cancelTimeframe'] = null;
schemas.nonOrCase['primaryCancelReason'] = null;
schemas.nonOrCase['cancelComments'] = null;
schemas.nonOrCase['diagnosticTherapeutic'] = null;
schemas.nonOrCase['principalDiagnosis'] = null;
schemas.nonOrCase['specimens'] = null;
schemas.nonOrCase['operativeFindings'] = null;
schemas.nonOrCase['plannedPrinDiagCode'] = null;
schemas.nonOrCase['location'] = null;
schemas.nonOrCase['procedureDate'] = null;
schemas.nonOrCase['procedureStartTime'] = null;
schemas.nonOrCase['procedureEndTime'] = null;
schemas.nonOrCase['provider'] = null;
schemas.nonOrCase['attendingProvider'] = null;
schemas.nonOrCase['medicalSpecialty'] = null;
schemas.nonOrCase['procedureOccurence'] = null;
schemas.nonOrCase['dictatedSummary'] = null;

// PLACEHOLDER CASE
schemas.placeholderCase = schemas.case;
schemas.placeholderCase['caseScheduleType'] = null;
schemas.placeholderCase['surgerySpecialty'] = null;
schemas.placeholderCase['primarySurgeon'] = null;
schemas.placeholderCase['otherPreopDiagnosis'] = null;
schemas.placeholderCase['referringPhysician'] = null;
schemas.placeholderCase['principalPreOpDiagnosis'] = null;
schemas.placeholderCase['prinPreOpDiagICD'] = null;
schemas.placeholderCase['surgeryPosition'] = null;
schemas.placeholderCase['principalPreOpICD'] = null;
schemas.placeholderCase['palliation'] = null;
schemas.placeholderCase['specialEquipment'] = null;
schemas.placeholderCase['plannedProsthImplant'] = null;

// REQUESTED CASE
schemas.requestedCase = schemas.placeholderCase;
schemas.requestedCase['orRoom'] = null;
schemas.requestedCase['serviceConnected'] = null;
schemas.requestedCase['plannedAdmissionStatus'] = null;
schemas.requestedCase['hospitalAdmissionStatus'] = null;
schemas.requestedCase['caseScheduleOrder'] = null;
schemas.requestedCase['preOpInfection'] = null;
schemas.requestedCase['firstAsst'] = null;
schemas.requestedCase['secondAsst'] = null;
schemas.requestedCase['attendingSurgeon'] = null;
schemas.requestedCase['princAnesthetist'] = null;
schemas.requestedCase['anesthesiologistSupvr'] = null;
schemas.requestedCase['reqAneTechnique'] = null;
schemas.requestedCase['reqFrozSect'] = null;
schemas.requestedCase['reqPreopXray'] = null;
schemas.requestedCase['intraoperativeXrays'] = null;
schemas.requestedCase['reqPhoto'] = null;
schemas.requestedCase['reqBloodKind'] = null;
schemas.requestedCase['surgeryScheduler'] = null;
schemas.requestedCase['cancelDate'] = null;
schemas.requestedCase['cancelTimeframe'] = null;
schemas.requestedCase['primaryCancelReason'] = null;
schemas.requestedCase['cancelComments'] = null;
schemas.requestedCase['concurrentCase'] = null;
schemas.requestedCase['requestBloodAvailability'] = null;
schemas.requestedCase['bloodProductInfo'] = null;
schemas.requestedCase['preAdmissionTesting'] = null;
schemas.requestedCase['specialSupplies'] = null;
schemas.requestedCase['specialInstruments'] = null;
schemas.requestedCase['pharmacyItems'] = null;

// SCHEDULED CASE
schemas.scheduledCase = schemas.requestedCase;
schemas.scheduledCase['scheduledStartTime'] = null;
schemas.scheduledCase['scheduledEndTime'] = null;


module.exports = schemas;  