/** config model **/

// required imports to define schema
const mongoose = require('mongoose');
const Schema = mongoose.Schema;

/** 
model of the schema this was derived from Mike Barlows
swagger api code

                "ProcedureCode": {
                    "description": "Array of Procedure Codes",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "ComplexityLevel": {
                    "description": "Array of Complexity Level values",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "ComplexityCategory": {
                    "description": "Array of Complexity Category values",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "AssessmentEligibilityCategory": {
                    "description": "Array of Assessment Eligibility Category values",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "VASQIPeligibility": {
                    "description": "Array of VASQIP eligibility values",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }

**/
const ConfigSchema = new Schema({
  ProcedureCode : [String],
  ComplexityLevel : [String],
  ComplexityCategory : [String],
  AssessmentEligibilityCategory : [String],
  VASQIPeligibility : [String]
});

// this declares that the model 'config' is tied to the Config Schema
mongoose.model('Config', ConfigSchema);